/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import org.apache.felix.cm.impl.ConfigurationAdapter;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPermission;

public class ConfigurationAdminImpl
implements ConfigurationAdmin {
    private ConfigurationManager configurationManager;
    private Bundle bundle;

    ConfigurationAdminImpl(ConfigurationManager configurationManager, Bundle bundle) {
        this.configurationManager = configurationManager;
        this.bundle = bundle;
    }

    void dispose() {
        this.bundle = null;
        this.configurationManager = null;
    }

    Bundle getBundle() {
        return this.bundle;
    }

    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        return this.wrap(this.configurationManager.createFactoryConfiguration(this, factoryPid));
    }

    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        this.checkPermission();
        return this.wrap(this.configurationManager.createFactoryConfiguration(factoryPid, location));
    }

    public Configuration getConfiguration(String pid) throws IOException {
        ConfigurationImpl config = this.configurationManager.getConfiguration(pid, this.getBundle().getLocation());
        if (config.getBundleLocation() == null) {
            config.setBundleLocation(this.getBundle().getLocation());
        } else if (!config.getBundleLocation().equals(this.getBundle().getLocation())) {
            this.checkPermission();
        }
        return this.wrap(config);
    }

    public Configuration getConfiguration(String pid, String location) throws IOException {
        this.checkPermission();
        return this.wrap(this.configurationManager.getConfiguration(pid, location));
    }

    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        ConfigurationImpl[] ci = this.configurationManager.listConfigurations(this, filter);
        if (ci == null || ci.length == 0) {
            return null;
        }
        Configuration[] cfgs = new Configuration[ci.length];
        for (int i = 0; i < cfgs.length; ++i) {
            cfgs[i] = this.wrap(ci[i]);
        }
        return cfgs;
    }

    private Configuration wrap(ConfigurationImpl configuration) {
        return new ConfigurationAdapter(this, configuration);
    }

    boolean hasPermission() {
        return this.bundle.hasPermission((Object)new ConfigurationPermission("*", "configure"));
    }

    void checkPermission() {
        if (!this.hasPermission()) {
            throw new SecurityException("Bundle " + this.bundle.getSymbolicName() + " not permitted for Configuration Tasks");
        }
    }
}

