/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.statistics.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.api.statistics.Statistic;

public abstract class StatisticImpl
implements Statistic,
Serializable {
    private String statisticDesc = "description";
    private AtomicLong sampleTime = new AtomicLong(System.currentTimeMillis());
    private String statisticName = "name";
    private AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
    private String statisticUnit = "unit";
    public static final String UNIT_COUNT = "count";
    public static final String UNIT_SECOND = "second";
    public static final String UNIT_MILLISECOND = "millisecond";
    public static final String UNIT_MICROSECOND = "microsecond";
    public static final String UNIT_NANOSECOND = "nanosecond";
    protected Map<String, Object> statMap = new ConcurrentHashMap<String, Object>();
    protected static final String NEWLINE = System.getProperty("line.separator");

    protected StatisticImpl(String name, String unit, String desc, long start_time, long sample_time) {
        this.statisticName = name;
        this.statisticUnit = unit;
        this.statisticDesc = desc;
        this.startTime.set(start_time);
        this.sampleTime.set(sample_time);
    }

    protected StatisticImpl(String name, String unit, String desc) {
        this.statisticName = name;
        this.statisticUnit = unit;
        this.statisticDesc = desc;
    }

    public synchronized Map getStaticAsMap() {
        this.statMap.put("name", this.statisticName);
        this.statMap.put("unit", this.statisticUnit);
        this.statMap.put("description", this.statisticDesc);
        this.statMap.put("starttime", this.startTime.get());
        this.statMap.put("lastsampletime", this.sampleTime.get());
        return this.statMap;
    }

    public String getName() {
        return this.statisticName;
    }

    public synchronized void setName(String name) {
        this.statisticName = name;
    }

    public String getDescription() {
        return this.statisticDesc;
    }

    public synchronized void setDescription(String desc) {
        this.statisticDesc = desc;
    }

    public String getUnit() {
        return this.statisticUnit;
    }

    public synchronized void setUnit(String unit) {
        this.statisticUnit = unit;
    }

    public long getLastSampleTime() {
        return this.sampleTime.get();
    }

    public void setLastSampleTime(long sample_time) {
        this.sampleTime.set(sample_time);
    }

    public long getStartTime() {
        return this.startTime.get();
    }

    public void setStartTime(long start_time) {
        this.startTime.set(start_time);
    }

    public String toString() {
        return "Statistic " + this.getClass().getName() + NEWLINE + "Name: " + this.getName() + NEWLINE + "Description: " + this.getDescription() + NEWLINE + "Unit: " + this.getUnit() + NEWLINE + "LastSampleTime: " + this.getLastSampleTime() + NEWLINE + "StartTime: " + this.getStartTime();
    }
}

