/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesAttribute;
import javax.validation.ReportAsSingleViolation;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.ConstraintHelper;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validation.util.annotationfactory.AnnotationFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T> {
    private static final Logger log = LoggerFactory.make();
    private static final Class<?>[] DEFAULT_GROUP = new Class[]{Default.class};
    private static final int OVERRIDES_PARAMETER_DEFAULT_INDEX = -1;
    private final T annotation;
    private final List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorDefinitonClasses = new ArrayList();
    private final Set<Class<?>> groups;
    private final Map<String, Object> attributes;
    private final Set<ConstraintDescriptor<?>> composingConstraints = new HashSet();
    private final boolean isReportAsSingleInvalidConstraint;
    private final ConstraintHelper constraintHelper;

    public ConstraintDescriptorImpl(T annotation, Class<?>[] groups, ConstraintHelper constraintHelper, Class<?> implicitGroup) {
        this(annotation, groups, constraintHelper);
        this.groups.add(implicitGroup);
    }

    public ConstraintDescriptorImpl(T annotation, Class<?>[] groups, ConstraintHelper constraintHelper) {
        this(annotation, new HashSet(), constraintHelper);
        if (groups.length == 0) {
            groups = DEFAULT_GROUP;
        }
        this.groups.addAll(Arrays.asList(groups));
    }

    private ConstraintDescriptorImpl(T annotation, Set<Class<?>> groups, ConstraintHelper constraintHelper) {
        this.annotation = annotation;
        this.groups = groups;
        this.attributes = this.getAnnotationParameters((Annotation)annotation);
        this.constraintHelper = constraintHelper;
        this.isReportAsSingleInvalidConstraint = annotation.annotationType().isAnnotationPresent(ReportAsSingleViolation.class);
        this.findConstraintValidatorClasses();
        Map<ClassIndexWrapper, Map<String, Object>> overrideParameters = this.parseOverrideParameters();
        this.parseComposingConstraints(overrideParameters);
    }

    private void findConstraintValidatorClasses() {
        if (this.constraintHelper.containsConstraintValidatorDefinition(this.annotation.annotationType())) {
            for (Class<? extends ConstraintValidator<? extends Annotation, ?>> clazz : this.constraintHelper.getConstraintValidatorDefinition(this.annotation.annotationType())) {
                this.constraintValidatorDefinitonClasses.add(clazz);
            }
            return;
        }
        ArrayList constraintDefinitonClasses = new ArrayList();
        if (this.constraintHelper.isBuiltinConstraint(this.annotation.annotationType())) {
            constraintDefinitonClasses.addAll(this.constraintHelper.getBuiltInConstraints(this.annotation.annotationType()));
        } else {
            Class<? extends Annotation> clazz = this.annotation.annotationType();
            Class<? extends ConstraintValidator<?, ?>>[] validatedBy = clazz.getAnnotation(Constraint.class).validatedBy();
            constraintDefinitonClasses.addAll(Arrays.asList(validatedBy));
        }
        this.constraintHelper.addConstraintValidatorDefinition(this.annotation.annotationType(), constraintDefinitonClasses);
        Iterator iterator = constraintDefinitonClasses.iterator();
        while (iterator.hasNext()) {
            Class validator;
            Class safeValidator = validator = (Class)iterator.next();
            this.constraintValidatorDefinitonClasses.add(safeValidator);
        }
    }

    @Override
    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public Set<Class<?>> getGroups() {
        return Collections.unmodifiableSet(this.groups);
    }

    @Override
    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return Collections.unmodifiableList(this.constraintValidatorDefinitonClasses);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return Collections.unmodifiableSet(this.composingConstraints);
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return this.isReportAsSingleInvalidConstraint;
    }

    public String toString() {
        return "ConstraintDescriptorImpl{annotation=" + this.annotation + ", constraintValidatorDefinitonClasses=" + this.constraintValidatorDefinitonClasses.toString() + ", groups=" + this.groups + ", attributes=" + this.attributes + ", composingConstraints=" + this.composingConstraints + ", isReportAsSingleInvalidConstraint=" + this.isReportAsSingleInvalidConstraint + '}';
    }

    private Map<String, Object> getAnnotationParameters(Annotation annotation) {
        Method[] declaredMethods = annotation.annotationType().getDeclaredMethods();
        HashMap<String, Object> parameters = new HashMap<String, Object>(declaredMethods.length);
        for (Method m : declaredMethods) {
            try {
                parameters.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to read annotation attributes: " + annotation.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to read annotation attributes: " + annotation.getClass(), e);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }

    private Object getMethodValue(Annotation annotation, Method m) {
        Object value;
        try {
            value = m.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        return value;
    }

    private Map<ClassIndexWrapper, Map<String, Object>> parseOverrideParameters() {
        HashMap<ClassIndexWrapper, Map<String, Object>> overrideParameters = new HashMap<ClassIndexWrapper, Map<String, Object>>();
        for (Method m : this.annotation.annotationType().getMethods()) {
            if (m.getAnnotation(OverridesAttribute.class) != null) {
                this.addOverrideAttributes(overrideParameters, this.getMethodValue((Annotation)this.annotation, m), m.getAnnotation(OverridesAttribute.class));
                continue;
            }
            if (m.getAnnotation(OverridesAttribute.List.class) == null) continue;
            this.addOverrideAttributes(overrideParameters, this.getMethodValue((Annotation)this.annotation, m), m.getAnnotation(OverridesAttribute.List.class).value());
        }
        return overrideParameters;
    }

    private void addOverrideAttributes(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, Object value, OverridesAttribute ... attributes) {
        for (OverridesAttribute attribute : attributes) {
            ClassIndexWrapper wrapper = new ClassIndexWrapper(attribute.constraint(), attribute.constraintIndex());
            Map<String, Object> map = overrideParameters.get(wrapper);
            if (map == null) {
                map = new HashMap<String, Object>();
                overrideParameters.put(wrapper, map);
            }
            map.put(attribute.name(), value);
        }
    }

    private void parseComposingConstraints(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters) {
        for (Annotation declaredAnnotation : this.annotation.annotationType().getDeclaredAnnotations()) {
            if (this.constraintHelper.isConstraintAnnotation(declaredAnnotation) || this.constraintHelper.isBuiltinConstraint(declaredAnnotation.annotationType())) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(declaredAnnotation, overrideParameters, -1);
                this.composingConstraints.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                continue;
            }
            if (!this.constraintHelper.isMultiValueConstraint(declaredAnnotation)) continue;
            List<Annotation> multiValueConstraints = this.constraintHelper.getMultiValueConstraints(declaredAnnotation);
            int index = 1;
            for (Annotation constraintAnnotation : multiValueConstraints) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(constraintAnnotation, overrideParameters, index);
                this.composingConstraints.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                ++index;
            }
        }
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(U declaredAnnotation, Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index) {
        Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
        return this.createComposingConstraintDescriptor(overrideParameters, index, declaredAnnotation, annotationType);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index, U constraintAnnotation, Class<U> annotationType) {
        AnnotationDescriptor<U> annotationDescriptor = new AnnotationDescriptor<U>(annotationType, this.getAnnotationParameters(constraintAnnotation));
        Map<String, Object> overrides = overrideParameters.get(new ClassIndexWrapper(annotationType, index));
        if (overrides != null) {
            for (Map.Entry<String, Object> entry : overrides.entrySet()) {
                annotationDescriptor.setValue(entry.getKey(), entry.getValue());
            }
        }
        U annotationProxy = AnnotationFactory.create(annotationDescriptor);
        return new ConstraintDescriptorImpl<U>(annotationProxy, this.groups, this.constraintHelper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassIndexWrapper {
        final Class<?> clazz;
        final int index;

        ClassIndexWrapper(Class<?> clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassIndexWrapper that = (ClassIndexWrapper)o;
            if (this.index != that.index) {
                return false;
            }
            return !(this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null);
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }
    }
}

