/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="attach-agent")
@Scoped(value=PerLookup.class)
@I18n(value="attach.agent")
public class AttachAgent
implements AdminCommand {
    @Inject
    ServerEnvironmentImpl env;
    @Param(primary=true)
    private String pid;
    @Param(optional=true)
    private String options;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AttachAgent.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            VirtualMachine vm = VirtualMachine.attach(this.pid);
            File dir = this.env.getLibPath();
            if (dir.isDirectory()) {
                File agentJar = new File(dir, "btrace-agent.jar");
                if (agentJar.isFile()) {
                    if (this.options == null) {
                        vm.loadAgent(agentJar.getPath());
                    } else {
                        vm.loadAgent(agentJar.getPath(), this.options);
                    }
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                } else {
                    report.setMessage(this.localStrings.getLocalString("attach.agent.exception", "btrace-agent.jar does not exist under {0}", new Object[]{dir}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
            } else {
                report.setMessage(this.localStrings.getLocalString("attach.agent.exception", "btrace-agent.jar directory {0} does not exist", new Object[]{dir}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        catch (Exception e) {
            report.setMessage(this.localStrings.getLocalString("attach.agent.exception", "Encountered exception during agent attach {0}", new Object[]{e.getMessage()}));
            e.printStackTrace();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

