/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.amx;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.api.amx.AMXValues;

public class MBeanListener
implements NotificationListener {
    private final String mType;
    private final String mName;
    private final MBeanServer mMBeanServer;
    private final Callback mCallback;

    public String getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public MBeanServer getMBeanServer() {
        return this.mMBeanServer;
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public MBeanListener(MBeanServer server, String type, Callback callback) {
        this(server, type, null, callback);
    }

    public MBeanListener(MBeanServer server, String type, String name, Callback callback) {
        this.mMBeanServer = server;
        this.mType = type;
        this.mName = name;
        this.mCallback = callback;
    }

    public static MBeanListener listenForDomainRoot(MBeanServer server, Callback callback) {
        String type = AMXValues.domainRoot().getKeyProperty("type");
        return new MBeanListener(server, type, callback);
    }

    public void start() {
        try {
            this.mMBeanServer.addNotificationListener(AMXValues.getMBeanServerDelegateObjectName(), this, null, (Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't add NotificationListener", e);
        }
        String props = "type=" + this.mType;
        if (this.mName != null) {
            props = props + "," + "name" + this.mName;
        }
        ObjectName pattern = AMXValues.newObjectName(AMXValues.amxJMXDomain(), props);
        Set<ObjectName> matched = this.mMBeanServer.queryNames(pattern, null);
        for (ObjectName objectName : matched) {
            this.mCallback.mbeanRegistered(objectName, this);
        }
    }

    public void stop() {
        try {
            this.mMBeanServer.removeNotificationListener(AMXValues.getMBeanServerDelegateObjectName(), this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't remove NotificationListener", e);
        }
    }

    public void handleNotification(Notification notifIn, Object handback) {
        if (notifIn instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            String mbeanType = objectName.getKeyProperty("type");
            String mbeanName = objectName.getKeyProperty("name");
            if (this.mType.equals(mbeanType) && this.mName != null && this.mName.equals(mbeanName)) {
                String notifType = notif.getType();
                if ("JMX.mbean.registered".equals(notifType)) {
                    this.mCallback.mbeanRegistered(objectName, this);
                } else if ("JMX.mbean.unregistered".equals(notifType)) {
                    this.mCallback.mbeanUnregistered(objectName, this);
                }
            }
        }
    }

    public static interface Callback {
        public void mbeanRegistered(ObjectName var1, MBeanListener var2);

        public void mbeanUnregistered(ObjectName var1, MBeanListener var2);
    }
}

