/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.LocalCommand;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.commands.CommandTable;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLICommand {
    public static final int ERROR = 1;
    public static final int CONNECTION_ERROR = 2;
    public static final int INVALID_COMMAND_ERROR = 3;
    public static final int SUCCESS = 0;
    private static final CLIDescriptorsReader cliDescriptorsReader;
    private static final Set<String> unsupported;
    private static final String UNSUPPORTED_CMD_FILE_NAME = "unsupported-legacy-command-names";
    private static final CommandTable localCommands;
    private static final LocalStringsImpl strings;
    protected static final CLILogger logger;
    protected String name;
    protected ProgramOptions po;
    protected Environment env;
    protected String[] args;
    protected Set<ValidOption> commandOpts;
    protected String operandType;
    protected int operandMin;
    protected int operandMax;
    protected Map<String, String> options;
    protected List<String> operands;
    protected Map<String, String> passwords;

    public static CLICommand getCommand(String name, ProgramOptions po, Environment env) throws CommandException {
        CLICommand.checkUnsupportedLegacyCommand(name);
        CLICommand cmd = CLICommand.getCommandClass(name, po, env);
        if (cmd != null) {
            return cmd;
        }
        try {
            if (cliDescriptorsReader.getCommand(name) != null) {
                return new LocalCommand(name, po, env);
            }
        }
        catch (CommandValidationException ex) {
            // empty catch block
        }
        return new RemoteCommand(name, po, env);
    }

    private static CLICommand getCommandClass(String name, ProgramOptions po, Environment env) {
        try {
            Class<?> cls = (Class<?>)localCommands.get(name);
            if (cls == null) {
                cls = Class.forName(CLICommand.nameToClass(name));
            }
            Constructor<?> cons = cls.getConstructor(String.class, ProgramOptions.class, Environment.class);
            return (CLICommand)cons.newInstance(name, po, env);
        }
        catch (Exception ex) {
            logger.printDebugMessage("Failed to load command class: " + ex);
            return null;
        }
    }

    private static String nameToClass(String name) {
        StringBuilder sb = new StringBuilder("com.sun.enterprise.admin.cli.commands.");
        boolean makeUpper = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (makeUpper && Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            if (c == '-') {
                makeUpper = true;
                continue;
            }
            makeUpper = false;
            sb.append(c);
        }
        sb.append("Command");
        logger.printDebugMessage("Command class: " + sb.toString());
        return sb.toString();
    }

    protected CLICommand(String name, ProgramOptions po, Environment env) {
        this.name = name;
        this.po = po;
        this.env = env;
        this.initializeLogger();
    }

    protected static void addOption(Set<ValidOption> opts, String name, char sname, String type, boolean req, String def) {
        ValidOption opt = new ValidOption(name, type, req ? 1 : 2, def);
        if (sname != '\u0000') {
            String abbr = Character.toString(sname);
            opt.setShortName(abbr);
        }
        opts.add(opt);
    }

    public int execute(String[] args) throws CommandException {
        this.args = args;
        this.initializePasswords();
        this.prepare();
        this.parse();
        this.validate();
        return this.executeCommand();
    }

    protected void initializeLogger() {
        if (this.po.isTerse()) {
            logger.setOutputLevel(Level.INFO);
        } else {
            logger.setOutputLevel(Level.FINE);
        }
        if (this.po.isEcho()) {
            logger.printMessage(this.toString());
        } else if (logger.isDebug()) {
            logger.printDebugMessage(this.toString());
        }
    }

    protected void initializePasswords() throws CommandException {
        this.passwords = new HashMap<String, String>();
        String pwfile = this.po.getPasswordFile();
        if (CLICommand.ok(pwfile)) {
            this.passwords = CLIUtil.readPasswordFileOptions(pwfile, true);
            logger.printDebugMessage("Passwords from password file " + this.passwords);
            String password = this.passwords.get("AS_ADMIN_PASSWORD");
            if (CLICommand.ok(password)) {
                this.po.setPassword(password);
            }
        }
    }

    protected abstract void prepare() throws CommandException;

    protected void parse() throws CommandException {
        if (this.po.isHelp()) {
            this.options = new HashMap<String, String>();
            this.options.put("help", "true");
            this.operands = Collections.emptyList();
        } else {
            try {
                Parser rcp = new Parser(this.args, 0, this.commandOpts, false);
                this.options = rcp.getOptions();
                this.operands = rcp.getOperands();
            }
            catch (CommandValidationException ex) {
                throw new CommandException(ex.getMessage());
            }
        }
        logger.printDebugMessage("params: " + this.options);
        logger.printDebugMessage("operands: " + this.operands);
    }

    protected void validate() throws CommandException {
        if (this.operands.size() < this.operandMin) {
            throw new CommandException(strings.get("notEnoughOperands", new Object[]{this.name, this.operandType}));
        }
        if (this.operands.size() > this.operandMax) {
            if (this.operandMax == 0) {
                throw new CommandException(strings.get("noOperandsAllowed", new Object[]{this.name}));
            }
            if (this.operandMax == 1) {
                throw new CommandException(strings.get("tooManyOperands1", new Object[]{this.name}));
            }
            throw new CommandException(strings.get("tooManyOperands", new Object[]{this.name, this.operandMax}));
        }
        boolean missingOption = false;
        for (ValidOption opt : this.commandOpts) {
            if (opt.isValueRequired() != 1 || opt.getType().equals("PASSWORD") || this.getParam(opt.getName()) != null) continue;
            missingOption = true;
            System.out.println(strings.get("missingOption", new Object[]{"--" + opt.getName()}));
        }
        if (missingOption) {
            throw new CommandException(strings.get("missingOptions", new Object[]{this.name}));
        }
        this.initializeCommandPassword();
    }

    private String getParam(String name) {
        String value = this.options.get(name);
        if (value == null) {
            value = this.env.getStringOption(name);
        }
        return value;
    }

    protected abstract int executeCommand() throws CommandException;

    private void initializeCommandPassword() throws CommandException {
        for (ValidOption opt : this.commandOpts) {
            if (!opt.getType().equals("PASSWORD")) continue;
            String pwdname = opt.getName();
            if (CLICommand.ok(this.passwords.get(pwdname))) {
                this.options.put(pwdname, this.passwords.get(pwdname));
                continue;
            }
            if (opt.isValueRequired() != 1) continue;
            try {
                String pwd = this.getPassword(opt.getName());
                if (pwd == null) {
                    throw new CommandException(strings.get("missingPassword", new Object[]{this.name, pwdname}));
                }
                this.passwords.put(pwdname, pwd);
                this.options.put(pwdname, pwd);
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
    }

    protected String getPassword(String passwordName) throws CommandValidationException {
        if (!this.po.isInteractive()) {
            return null;
        }
        String newprompt = strings.get("NewPasswordPrompt", new Object[]{passwordName});
        String confirmationPrompt = strings.get("NewPasswordConfirmationPrompt", new Object[]{passwordName});
        String newpassword = this.readPassword(newprompt);
        if (!this.isPasswordValid(newpassword)) {
            throw new CommandValidationException(strings.get("PasswordLimit", new Object[]{passwordName}));
        }
        String newpasswordAgain = this.readPassword(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", new Object[]{passwordName}));
        }
        return newpassword;
    }

    protected String readPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s ", prompt);
            password = new String(pc);
        }
        return password;
    }

    protected boolean isPasswordValid(String passwd) {
        return passwd.length() >= 8;
    }

    private static void checkUnsupportedLegacyCommand(String cmd) throws CommandException {
        for (String c : unsupported) {
            if (!c.equals(cmd)) continue;
            throw new CommandException("Previously supported command: " + cmd + " is not supported for this release.");
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void file2Set(String file, Set<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = CLICommand.class.getClassLoader().getResourceAsStream(file);
            if (is == null) {
                return;
            }
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        localCommands = new CommandTable();
        strings = new LocalStringsImpl(CLICommand.class);
        logger = CLILogger.getInstance();
        cliDescriptorsReader = CLIDescriptorsReader.getInstance();
        cliDescriptorsReader.setSerializeDescriptorsProperty(1);
        HashSet<String> unsup = new HashSet<String>();
        CLICommand.file2Set(UNSUPPORTED_CMD_FILE_NAME, unsup);
        unsupported = Collections.unmodifiableSet(unsup);
    }
}

