/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.commands.CommandTable;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

public class ListCommandsCommand
extends RemoteCommand {
    String[] remoteCommands;
    String[] localCommands;
    boolean localOnly;
    boolean remoteOnly;
    private static final String SPACES = "                                                            ";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListCommandsCommand.class);

    public ListCommandsCommand(String name, ProgramOptions po, Environment env) throws CommandException {
        super(name, po, env);
    }

    protected void fetchCommandMetadata() {
        HashSet<ValidOption> opts = new HashSet<ValidOption>();
        ListCommandsCommand.addOption(opts, "localonly", '\u0000', "BOOLEAN", false, "false");
        ListCommandsCommand.addOption(opts, "remoteonly", '\u0000', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected void validate() throws CommandException {
        super.validate();
        this.localOnly = this.getBooleanOption("localonly");
        this.remoteOnly = this.getBooleanOption("remoteonly");
        if (this.localOnly && this.remoteOnly) {
            throw new CommandException(strings.get("listCommands.notBoth"));
        }
    }

    private boolean getBooleanOption(String name) {
        String val = (String)this.options.get(name);
        return val != null && Boolean.parseBoolean(val);
    }

    public int executeCommand() throws CommandException {
        this.args = new String[0];
        this.options = new HashMap();
        this.operands = Collections.emptyList();
        if (!this.remoteOnly) {
            this.getLocalCommands();
            this.printLocalCommands();
        }
        if (!this.localOnly) {
            this.getRemoteCommands();
            this.printRemoteCommands();
        }
        logger.printMessage("");
        return 0;
    }

    String[] getLocalCommands() throws CommandException {
        ArrayList names = new ArrayList();
        names.addAll(new CommandTable().keySet());
        this.localCommands = names.toArray(new String[names.size()]);
        Arrays.sort(this.localCommands);
        return this.localCommands;
    }

    String[] getRemoteCommands() throws CommandException {
        int ret = -1;
        try {
            logger.pushAndLockLevel(Level.WARNING);
            ret = super.executeCommand();
        }
        catch (Exception e) {
            throw new CommandException(strings.get("LocalRemoteCommand.errorRemote", new Object[]{e.getMessage()}));
        }
        finally {
            logger.popAndUnlockLevel();
        }
        if (ret == 0) {
            Map<String, String> mainAtts = this.getMainAtts();
            String cmds = mainAtts.get("children");
            this.remoteCommands = cmds.split(";");
        }
        return this.remoteCommands;
    }

    void printLocalCommands() {
        logger.printMessage("********** Local Commands **********");
        for (String s : this.localCommands) {
            logger.printMessage(s);
        }
    }

    void printRemoteCommands() {
        logger.printMessage("********** Remote Commands **********");
        int num = this.remoteCommands.length;
        int offset = num / 2 + num % 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append(this.remoteCommands[i]);
            sb.append(this.justify(this.remoteCommands[i], 40));
            if (i + offset < num) {
                sb.append(this.remoteCommands[i + offset]);
            }
            if (i >= offset - 1) continue;
            sb.append(CLIConstants.EOL);
        }
        logger.printMessage(sb.toString());
    }

    private String justify(String s, int width) {
        int numSpaces = width - s.length();
        return SPACES.substring(0, numSpaces);
    }
}

