/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.BeanDescriptor;
import javax.validation.GroupSequence;
import javax.validation.PropertyDescriptor;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.BeanDescriptorImpl;
import org.hibernate.validation.engine.BeanMetaData;
import org.hibernate.validation.engine.ConstraintDescriptorImpl;
import org.hibernate.validation.engine.ConstraintHelper;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.engine.PropertyDescriptorImpl;
import org.hibernate.validation.engine.xml.AnnotationIgnores;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Logger log = LoggerFactory.make();
    private final Class<T> beanClass;
    private BeanDescriptorImpl<T> beanDescriptor;
    private List<MetaConstraint<T, ? extends Annotation>> metaConstraintList = new ArrayList<MetaConstraint<T, ? extends Annotation>>();
    private List<Member> cascadedMembers = new ArrayList<Member>();
    private Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private List<Class<?>> defaultGroupSequence = new ArrayList();
    private final ConstraintHelper constraintHelper;

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper) {
        this(beanClass, constraintHelper, new AnnotationIgnores());
    }

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper, AnnotationIgnores annotationIgnores) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.createMetaData(annotationIgnores);
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public List<Member> getCascadedMembers() {
        return this.cascadedMembers;
    }

    @Override
    public List<MetaConstraint<T, ? extends Annotation>> geMetaConstraintList() {
        return this.metaConstraintList;
    }

    public void addMetaConstraint(MetaConstraint<?, ? extends Annotation> metaConstraint) {
        this.metaConstraintList.add(metaConstraint);
    }

    public void addCascadedMember(Member member) {
        this.cascadedMembers.add(member);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String property) {
        return this.propertyDescriptors.get(property);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence() {
        return this.defaultGroupSequence;
    }

    public void setDefaultGroupSequence(List<Class<?>> groupSequence) {
        this.defaultGroupSequence = new ArrayList();
        for (Class<?> group : groupSequence) {
            if (group.getName().equals(this.beanClass.getName())) {
                this.defaultGroupSequence.add(Default.class);
                continue;
            }
            if (group.getName().equals(Default.class.getName())) {
                throw new ValidationException("'Default.class' cannot appear in default group sequence list.");
            }
            this.defaultGroupSequence.add(group);
        }
        if (log.isTraceEnabled()) {
            log.trace("Members of the default group sequence for bean {} are: {}", (Object)this.beanClass.getName(), this.defaultGroupSequence);
        }
    }

    @Override
    public Set<PropertyDescriptor> getConstrainedProperties() {
        return Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(this.propertyDescriptors.values()));
    }

    private void createMetaData(AnnotationIgnores annotationIgnores) {
        this.beanDescriptor = new BeanDescriptorImpl(this);
        this.initDefaultGroupSequence();
        ArrayList<Class> classes = new ArrayList<Class>();
        this.computeClassHierarchy(this.beanClass, classes);
        for (Class current : classes) {
            this.initClass(current, annotationIgnores);
        }
    }

    private void computeClassHierarchy(Class clazz, List<Class> classes) {
        if (log.isTraceEnabled()) {
            log.trace("Processing: {}", clazz);
        }
        for (Class current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                this.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private void initClass(Class clazz, AnnotationIgnores annotationIgnores) {
        this.initClassConstraints(clazz, annotationIgnores);
        this.initMethodConstraints(clazz, annotationIgnores);
        this.initFieldConstraints(clazz, annotationIgnores);
    }

    private void initDefaultGroupSequence() {
        ArrayList groupSequence = new ArrayList();
        GroupSequence groupSequenceAnnotation = this.beanClass.getAnnotation(GroupSequence.class);
        if (groupSequenceAnnotation == null) {
            groupSequence.add(this.beanClass);
        } else {
            groupSequence.addAll(Arrays.asList(groupSequenceAnnotation.value()));
        }
        this.setDefaultGroupSequence(groupSequence);
    }

    private <A extends Annotation> void initFieldConstraints(Class clazz, AnnotationIgnores annotationIgnores) {
        for (Field field : clazz.getDeclaredFields()) {
            List<ConstraintDescriptorImpl> fieldMetadata = this.findConstraints(field);
            for (ConstraintDescriptorImpl constraintDescription : fieldMetadata) {
                if (annotationIgnores.isIgnoreAnnotations(field)) break;
                ReflectionHelper.setAccessibility(field);
                MetaConstraint metaConstraint = new MetaConstraint(field, this.beanClass, constraintDescription);
                this.metaConstraintList.add(metaConstraint);
            }
            if (!field.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(field);
            this.cascadedMembers.add(field);
            this.addPropertyDescriptorForMember(field);
        }
    }

    private <A extends Annotation> void initMethodConstraints(Class clazz, AnnotationIgnores annotationIgnores) {
        for (Method method : clazz.getDeclaredMethods()) {
            List<ConstraintDescriptorImpl> methodMetadata = this.findConstraints(method);
            for (ConstraintDescriptorImpl constraintDescription : methodMetadata) {
                if (annotationIgnores.isIgnoreAnnotations(method)) break;
                ReflectionHelper.setAccessibility(method);
                MetaConstraint metaConstraint = new MetaConstraint(method, this.beanClass, constraintDescription);
                this.metaConstraintList.add(metaConstraint);
            }
            if (!method.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(method);
            this.cascadedMembers.add(method);
            this.addPropertyDescriptorForMember(method);
        }
    }

    private PropertyDescriptorImpl addPropertyDescriptorForMember(Member member) {
        String name = ReflectionHelper.getPropertyName(member);
        PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            propertyDescriptor = new PropertyDescriptorImpl(ReflectionHelper.getType(member), ((AnnotatedElement)((Object)member)).isAnnotationPresent(Valid.class), name);
            this.propertyDescriptors.put(name, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private <A extends Annotation> void initClassConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        if (annotationIgnores.isIgnoreAnnotations(clazz)) {
            return;
        }
        List<ConstraintDescriptorImpl> classMetadata = this.findClassLevelConstraints(clazz);
        for (ConstraintDescriptorImpl constraintDescription : classMetadata) {
            MetaConstraint metaConstraint = new MetaConstraint(this.beanClass, constraintDescription);
            this.metaConstraintList.add(metaConstraint);
        }
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl> findConstraintAnnotations(Class<?> clazz, A annotation) {
        ArrayList<ConstraintDescriptorImpl> constraintDescriptors = new ArrayList<ConstraintDescriptorImpl>();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        if (this.constraintHelper.isConstraintAnnotation(annotation) || this.constraintHelper.isBuiltinConstraint(annotation.annotationType())) {
            constraints.add(annotation);
        }
        constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl constraintDescriptor = this.buildConstraintDescriptor(clazz, constraint);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> ConstraintDescriptorImpl buildConstraintDescriptor(Class<?> clazz, A annotation) {
        Class[] groups = ReflectionHelper.getAnnotationParameter(annotation, "groups", Class[].class);
        ConstraintDescriptorImpl<A> constraintDescriptor = clazz.isInterface() ? new ConstraintDescriptorImpl<A>(annotation, groups, this.constraintHelper, clazz) : new ConstraintDescriptorImpl<A>(annotation, groups, this.constraintHelper);
        return constraintDescriptor;
    }

    private List<ConstraintDescriptorImpl> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList<ConstraintDescriptorImpl> metadata = new ArrayList<ConstraintDescriptorImpl>();
        for (Annotation annotation : beanClass.getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(beanClass, annotation));
        }
        for (ConstraintDescriptorImpl constraintDescriptor : metadata) {
            this.beanDescriptor.addConstraintDescriptor(constraintDescriptor);
        }
        return metadata;
    }

    private List<ConstraintDescriptorImpl> findConstraints(Member member) {
        assert (member instanceof Field || member instanceof Method);
        ArrayList<ConstraintDescriptorImpl> metadata = new ArrayList<ConstraintDescriptorImpl>();
        for (Annotation annotation : ((AnnotatedElement)((Object)member)).getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(member.getDeclaringClass(), annotation));
        }
        String name = ReflectionHelper.getPropertyName(member);
        for (ConstraintDescriptorImpl constraintDescriptor : metadata) {
            if (member instanceof Method && name == null) {
                throw new ValidationException("Annotated methods must follow the JavaBeans naming convention. " + member.getName() + "() does not.");
            }
            PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
            if (propertyDescriptor == null) {
                propertyDescriptor = this.addPropertyDescriptorForMember(member);
            }
            propertyDescriptor.addConstraintDescriptor(constraintDescriptor);
        }
        return metadata;
    }
}

