/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine.resolver;

import java.lang.annotation.ElementType;
import javax.validation.TraversableResolver;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTraversableResolver
implements TraversableResolver {
    private static final Logger log = LoggerFactory.make();
    private static final String PERSISTENCE_UTIL_CLASS_NAME = "javax.persistence.PersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME = "org.hibernate.validation.engine.resolver.JPATraversableResolver";
    private TraversableResolver jpaTraversableResolver;

    public DefaultTraversableResolver() {
        this.detectJPA();
    }

    @Override
    public boolean isTraversable(Object traversableObject, String traversableProperty, Class<?> rootBeanType, String pathToTraversableObject, ElementType elementType) {
        return this.jpaTraversableResolver == null || this.jpaTraversableResolver.isTraversable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private void detectJPA() {
        try {
            ReflectionHelper.classForName(PERSISTENCE_UTIL_CLASS_NAME, this.getClass());
            log.debug("Found {} on classpath.", (Object)PERSISTENCE_UTIL_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            log.debug("Cannot find {} on classpath. All properties will per default be traversable.", (Object)PERSISTENCE_UTIL_CLASS_NAME);
            return;
        }
        try {
            Class<?> jpaAwareResolverClass = ReflectionHelper.classForName(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME, this.getClass());
            this.jpaTraversableResolver = (TraversableResolver)jpaAwareResolverClass.newInstance();
            log.info("Instantiated an instance of {}.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            log.info("Unable to load JPA aware resolver {}. All properties will per default be traversable.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
        catch (IllegalAccessException e) {
            log.info("Unable to instantiate JPA aware resolver {}. All properties will per default be traversable.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
        catch (InstantiationException e) {
            log.info("Unable to instantiate JPA aware resolver {}. All properties will per default be traversable.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
    }
}

