/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import java.util.Collection;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BtraceClientGenerator {
    public static byte[] generateBtraceClientClassData(int clientID, Collection<FlashlightProbe> probesRequiringTransformation, Class clientClazz) {
        Type classType = Type.getType(clientClazz);
        String generatedClassName = clientClazz.getName();
        generatedClassName = "BTrace_" + clientID + "_" + generatedClassName.replace('.', '/');
        int cwFlags = 3;
        ClassWriter cw = new ClassWriter(cwFlags);
        int access = 17;
        cw.visit(49, access, generatedClassName, null, "java/lang/Object", null);
        AnnotationVisitor av = cw.visitAnnotation("Lcom/sun/btrace/annotations/BTrace;", true);
        Type probeType = Type.getType(FlashlightProbe.class);
        int methodCounter = 0;
        for (FlashlightProbe probe : probesRequiringTransformation) {
            String methodDesc = "void __" + probe.getProviderJavaMethodName() + "__" + clientID + "_" + methodCounter + "_";
            methodDesc = methodDesc + "(";
            String delim = "";
            for (Class paramType : probe.getParamTypes()) {
                methodDesc = methodDesc + delim + paramType.getName();
                delim = ", ";
            }
            methodDesc = methodDesc + ")";
            Method m = Method.getMethod(methodDesc);
            GeneratorAdapter gen = new GeneratorAdapter(9, m, null, null, cw);
            av = gen.visitAnnotation("Lcom/sun/btrace/annotations/OnMethod;", true);
            av.visit("clazz", "" + probe.getProviderClazz().getName());
            av.visit("method", probe.getProviderJavaMethodName());
            av.visitEnd();
            gen.push(probe.getId());
            gen.loadArgArray();
            gen.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("void invokeProbe(int, Object[])"));
            gen.returnValue();
            gen.endMethod();
            ++methodCounter;
        }
        BtraceClientGenerator.generateConstructor(cw);
        cw.visitEnd();
        byte[] classData = cw.toByteArray();
        return classData;
    }

    private static void generateConstructor(ClassWriter cw) {
        Method m = Method.getMethod("void <init> ()");
        GeneratorAdapter gen = new GeneratorAdapter(1, m, null, null, cw);
        gen.loadThis();
        gen.invokeConstructor(Type.getType(Object.class), m);
        gen.returnValue();
        gen.endMethod();
    }
}

