/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GrizzlyListener;
import com.sun.enterprise.v3.services.impl.ServiceInitializerFilter;
import com.sun.enterprise.v3.services.impl.ServiceInitializerHandler;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.http.HttpProtocolChain;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;

public class ServiceInitializerThread
extends SelectorThread {
    protected static final ResourceBundle _rb = logger.getResourceBundle();
    private GrizzlyListener service;
    private Habitat habitat;

    public ServiceInitializerThread(GrizzlyListener grizzlyListener, Habitat h) {
        this.service = grizzlyListener;
        this.habitat = h;
        this.setClassLoader(this.getClass().getClassLoader());
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public GrizzlyListener getGrizzlyListener() {
        return this.service;
    }

    protected void initController() {
        super.initController();
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){
            private final ConcurrentLinkedQueue<ProtocolChain> chains = new ConcurrentLinkedQueue();

            public ProtocolChain poll() {
                ProtocolChain protocolChain = this.chains.poll();
                if (protocolChain == null) {
                    protocolChain = new HttpProtocolChain();
                    ServiceInitializerThread.this.configureFilters(protocolChain);
                }
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return this.chains.offer(instance);
            }
        };
        this.controller.setProtocolChainInstanceHandler(instanceHandler);
        this.controller.setReadThreadsCount(this.readThreadsCount);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ServiceInitializerThread.this.stopEndpoint();
            }
        });
    }

    public void configureFilters(ProtocolChain chain) {
        ServiceInitializerFilter readFilter = new ServiceInitializerFilter();
        chain.addFilter(readFilter);
    }

    protected TCPSelectorHandler createSelectorHandler() {
        return new ServiceInitializerHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpoint() {
        try {
            super.stopEndpoint();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unable to stop properly", t);
        }
        finally {
            try {
                if (this.selectorHandler != null && this.selectorHandler.getSelector() != null) {
                    this.selectorHandler.getSelector().close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void configure(NetworkListener networkListener) {
        this.setPort(Integer.parseInt(networkListener.getPort()));
        try {
            this.setAddress(InetAddress.getByName(networkListener.getAddress()));
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Invalid address for {0}: {1}", new Object[]{networkListener.getName(), networkListener.getAddress()});
        }
    }
}

