/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.admin.monitor;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import java.beans.PropertyChangeEvent;
import org.glassfish.api.Startup;
import org.glassfish.api.monitoring.TelemetryProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class TelemetryService
implements Startup,
PostConstruct,
ConfigListener {
    @Inject(optional=true)
    ModuleMonitoringLevels config = null;
    @Inject
    Habitat habitat;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        if (this.config != null) {
            if (!this.config.getWebContainer().equals("OFF")) {
                this.onLevelChange("web-container", this.config.getWebContainer());
            }
            if (!this.config.getJvm().equals("OFF")) {
                this.onLevelChange("jvm", this.config.getJvm());
            }
            if (!this.config.getThreadPool().equals("OFF")) {
                this.onLevelChange("thread-pool", this.config.getThreadPool());
            }
            if (!this.config.getHttpService().equals("OFF")) {
                this.onLevelChange("http-service", this.config.getHttpService());
            }
            if (!this.config.getJdbcConnectionPool().equals("OFF")) {
                this.onLevelChange("jdbc-connection-pool", this.config.getJdbcConnectionPool());
            }
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        for (PropertyChangeEvent event : propertyChangeEvents) {
            if (!(event.getSource() instanceof ModuleMonitoringLevels)) continue;
            String propName = event.getPropertyName();
            String enabled = event.getNewValue().toString();
            this.onLevelChange(propName, enabled);
        }
        return null;
    }

    private void onLevelChange(String propName, String enabled) {
        TelemetryProvider tp = (TelemetryProvider)this.habitat.getComponent(TelemetryProvider.class, propName);
        if (tp != null) {
            tp.onLevelChange(enabled);
        }
    }
}

