/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.amx;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.amx.AMXValues;
import org.glassfish.api.amx.BootAMXMBean;

public final class AMXUtil {
    private AMXUtil() {
    }

    public static void invokeBootAMX(MBeanServerConnection conn) {
        try {
            conn.invoke(BootAMXMBean.OBJECT_NAME, "bootAMX", null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static ObjectName invokeWaitAMXReady(MBeanServerConnection conn) {
        ObjectName domainRoot = AMXValues.domainRoot();
        try {
            conn.invoke(domainRoot, "waitAMXReady", null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return domainRoot;
    }

    public static ObjectName findDomainRoot(MBeanServerConnection conn) {
        ObjectName objectName = AMXValues.domainRoot();
        try {
            if (!conn.isRegistered(objectName)) {
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }

    public static ObjectName newObjectName(String s) {
        try {
            return new ObjectName(s);
        }
        catch (Exception e) {
            throw new RuntimeException("bad ObjectName", e);
        }
    }

    public static ObjectName newObjectName(String pp, String type2, String name) {
        String props = AMXUtil.prop("pp", pp) + "," + AMXUtil.prop("type", type2);
        if (name != null) {
            props = props + "," + AMXUtil.prop("name", name);
        }
        return AMXUtil.newObjectName(AMXValues.amxJMXDomain(), props);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return AMXUtil.newObjectName(domain + ":" + props);
    }

    public static ObjectName getMBeanServerDelegateObjectName() {
        return AMXUtil.newObjectName("JMImplementation", "type=MBeanServerDelegate");
    }

    public static String prop(String key, String value) {
        return key + "=" + value;
    }
}

