/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.config;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.module.bootstrap.Populator;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.config.Container;
import org.glassfish.config.support.GlassFishConfigBean;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DefaultConfigParser
implements org.glassfish.api.admin.config.ConfigParser {
    @Inject(name="default-instance-name")
    Config config;
    Logger logger = Logger.getLogger("javax.enterprise.system.core");

    public Container parseContainerConfig(Habitat habitat, final URL configuration) throws IOException {
        ConfigParser configParser = new ConfigParser(habitat);
        final DomDocument doc = new DomDocument(habitat){

            public Dom make(Habitat habitat, XMLStreamReader xmlStreamReader, Dom dom, ConfigModel configModel) {
                return new GlassFishConfigBean(habitat, (DomDocument)this, dom, configModel, xmlStreamReader);
            }
        };
        new Populator(){

            public void run(ConfigParser parser) {
                long now = System.currentTimeMillis();
                if (configuration != null) {
                    try {
                        DomDocument newElement = parser.parse(configuration, doc);
                        DefaultConfigParser.this.logger.info(newElement.getRoot().getProxyType().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Logger.getAnonymousLogger().fine("time to parse domain.xml : " + String.valueOf(System.currentTimeMillis() - now));
                }
            }
        }.run(configParser);
        final Container container = (Container)doc.getRoot().createProxy(Container.class);
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config config) throws PropertyVetoException, TransactionFailure {
                    config.getContainers().add(container);
                    return null;
                }
            }, (ConfigBeanProxy)this.config);
        }
        catch (TransactionFailure e) {
            this.logger.log(Level.SEVERE, "Cannot add new configuration to the Config element", e);
        }
        return container;
    }

    public <T extends Container> T parseContainerConfig(Habitat habitat, final URL configuration, Class<T> configType) throws IOException {
        ConfigParser configParser = new ConfigParser(habitat);
        final DomDocument doc = new DomDocument(habitat){

            public Dom make(Habitat habitat, XMLStreamReader xmlStreamReader, Dom dom, ConfigModel configModel) {
                return new GlassFishConfigBean(habitat, (DomDocument)this, dom, configModel, xmlStreamReader);
            }
        };
        new Populator(){

            public void run(ConfigParser parser) {
                long now = System.currentTimeMillis();
                if (configuration != null) {
                    try {
                        DomDocument newElement = parser.parse(configuration, doc);
                        DefaultConfigParser.this.logger.info(newElement.getRoot().getProxyType().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Logger.getAnonymousLogger().fine("time to parse domain.xml : " + String.valueOf(System.currentTimeMillis() - now));
                }
            }
        }.run(configParser);
        final Container container = (Container)doc.getRoot().createProxy(configType);
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config config) throws PropertyVetoException, TransactionFailure {
                    config.getContainers().add(container);
                    return null;
                }
            }, (ConfigBeanProxy)this.config);
        }
        catch (TransactionFailure e) {
            this.logger.log(Level.SEVERE, "Cannot add new configuration to the Config element", e);
        }
        return (T)container;
    }
}

