/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.embedded.Port;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class PortImpl
implements Port {
    @Inject
    CommandRunner runner = null;
    @Inject(name="plain")
    ActionReport report = null;
    String listenerName;

    public void bind(int portNumber) {
        Properties props = new Properties();
        props.put("listenerport", Integer.toString(portNumber));
        props.put("listeneraddress", "127.0.0.1");
        this.listenerName = this.getListenerName();
        props.put("listener_id", this.listenerName);
        props.put("servername", "");
        props.put("defaultvs", "server");
        this.runner.doCommand("create-http-listener", props, this.report);
    }

    private String getListenerName() {
        String listenerNameBase = "embedded-listener";
        int i = 1;
        String listenerName = "embedded-listener";
        while (this.existsListener(listenerName)) {
            listenerName = "embedded-listener-" + i++;
        }
        return listenerName;
    }

    private boolean existsListener(String listenerName) {
        return false;
    }

    public void unbind() {
        Properties props = new Properties();
        props.put("listener_id", this.listenerName);
        this.runner.doCommand("delete-http-listener", props, this.report);
    }
}

