/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.LocalRemoteCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class ListCommandsCommand
extends LocalRemoteCommand {
    String[] remoteCommands;
    String[] localCommands;
    String port;
    String host;
    String user;
    String passwordFile;
    boolean localOnly;
    boolean remoteOnly;
    private static final String SPACES = "                                                            ";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        if (!this.remoteOnly) {
            this.getLocalCommands();
            this.printLocalCommands();
        }
        if (!this.localOnly) {
            this.getRemoteCommands();
            this.printRemoteCommands();
        }
        logger.printMessage("");
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        this.localOnly = this.getBooleanOption("localonly");
        this.remoteOnly = this.getBooleanOption("remoteonly");
        if (this.localOnly && this.remoteOnly) {
            throw new CommandValidationException(strings.get("listCommands.notBoth"));
        }
        return true;
    }

    String[] getLocalCommands() throws CommandValidationException {
        CLIDescriptorsReader r = CLIDescriptorsReader.getInstance();
        Iterator it = r.getCommandsList().getCommands();
        ArrayList<String> names = new ArrayList<String>();
        while (it.hasNext()) {
            names.add(((ValidCommand)it.next()).getName());
        }
        this.localCommands = names.toArray(new String[names.size()]);
        Arrays.sort(this.localCommands);
        return this.localCommands;
    }

    String[] getRemoteCommands() throws CommandException {
        CLIRemoteCommand rc = this.runRemoteCommand("list-commands", new String[0]);
        Map<String, String> mainAtts = rc.getMainAtts();
        String cmds = mainAtts.get("children");
        this.remoteCommands = cmds.split(";");
        return this.remoteCommands;
    }

    void printLocalCommands() {
        logger.printMessage("********** Local Commands **********");
        for (String s : this.localCommands) {
            logger.printMessage(s);
        }
    }

    void printRemoteCommands() {
        logger.printMessage("********** Remote Commands **********");
        int num = this.remoteCommands.length;
        int offset = num / 2 + num % 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append(this.remoteCommands[i]);
            sb.append(this.justify(this.remoteCommands[i], 40));
            if (i + offset < num) {
                sb.append(this.remoteCommands[i + offset]);
            }
            if (i >= offset - 1) continue;
            sb.append(CLIConstants.EOL);
        }
        logger.printMessage(sb.toString());
    }

    private String justify(String s, int width) {
        int numSpaces = width - s.length();
        return SPACES.substring(0, numSpaces);
    }
}

