/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramOptions {
    private static final Set<ValidOption> programOptions;
    private static final Map<String, String> emptyOptions;
    private static final LocalStringsImpl strings;
    private Map<String, String> options;
    private String host;
    private int port;
    private String user;
    private String password;
    private String passwordFile;
    private boolean secure;
    private boolean terse;
    private boolean echo;
    private boolean interactive;
    private boolean help;
    private String[] programArguments;
    private String classPath;
    private String className;

    private static void addMetaOption(Set<ValidOption> opts, String name, char sname, String type, boolean req, String def) {
        ValidOption opt = new ValidOption(name, type, req ? 1 : 2, def);
        String abbr = Character.toString(sname);
        opt.setShortName(abbr);
        opts.add(opt);
    }

    public ProgramOptions(Environment env) throws CommandException {
        this(emptyOptions, env);
    }

    public ProgramOptions(Map<String, String> options, Environment env) throws CommandException {
        block5: {
            String sport;
            this.secure = false;
            this.terse = false;
            this.echo = false;
            this.interactive = false;
            this.help = false;
            this.echo = env.getBooleanOption("echo");
            this.terse = env.getBooleanOption("terse");
            this.interactive = env.hasOption("interactive") ? env.getBooleanOption("interactive") : System.console() != null;
            this.host = env.getStringOption("host");
            if (!ProgramOptions.ok(this.host)) {
                this.host = "localhost";
            }
            if (ProgramOptions.ok(sport = env.getStringOption("port"))) {
                String badPortMsg = strings.get("badport", new Object[]{sport});
                try {
                    this.port = Integer.parseInt(sport);
                    if (this.port < 1 || this.port > 65535) {
                        throw new CommandException(badPortMsg);
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    throw new CommandException(badPortMsg);
                }
            }
            this.port = 4848;
        }
        this.secure = env.getBooleanOption("secure");
        this.user = env.getStringOption("user");
        this.passwordFile = env.getStringOption("passwordfile");
        this.updateOptions(options);
    }

    public void updateOptions(Map<String, String> options) throws CommandException {
        String value;
        this.options = options;
        if (options.containsKey("echo")) {
            value = options.get("echo");
            this.echo = ProgramOptions.ok(value) ? Boolean.parseBoolean(value) : true;
        }
        if (options.containsKey("terse")) {
            value = options.get("terse");
            this.terse = ProgramOptions.ok(value) ? Boolean.parseBoolean(value) : true;
        }
        if (options.containsKey("interactive")) {
            value = options.get("interactive");
            this.interactive = ProgramOptions.ok(value) ? Boolean.parseBoolean(value) : true;
        }
        if (options.containsKey("help")) {
            this.help = true;
        }
        if (ProgramOptions.ok(value = options.get("host"))) {
            this.host = value;
        }
        if (ProgramOptions.ok(value = options.get("port"))) {
            String badPortMsg = strings.get("badport", new Object[]{value});
            try {
                this.port = Integer.parseInt(value);
                if (this.port < 1 || this.port > 65535) {
                    throw new CommandException(badPortMsg);
                }
            }
            catch (NumberFormatException e) {
                throw new CommandException(badPortMsg);
            }
        }
        if (options.containsKey("secure")) {
            value = options.get("secure");
            this.secure = ProgramOptions.ok(value) ? Boolean.parseBoolean(value) : true;
        }
        if (ProgramOptions.ok(value = options.get("user"))) {
            this.user = value;
        }
        if (ProgramOptions.ok(value = options.get("passwordfile"))) {
            this.passwordFile = value;
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static Set<ValidOption> getValidOptions() {
        return programOptions;
    }

    public void toEnvironment(Environment env) {
        this.putEnv(env, "echo");
        this.putEnv(env, "terse");
        this.putEnv(env, "interactive");
        this.putEnv(env, "host");
        this.putEnv(env, "port");
        this.putEnv(env, "secure");
        this.putEnv(env, "user");
    }

    private void putEnv(Environment env, String name) {
        String value = this.options.get(name);
        if (value != null) {
            env.putOption(name, value);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isTerse() {
        return this.terse;
    }

    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isOptionsSet() {
        return this.options != emptyOptions;
    }

    public String[] getProgramArguments() {
        return this.programArguments;
    }

    public void setProgramArguments(String[] programArguments) {
        this.programArguments = programArguments;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    static {
        strings = new LocalStringsImpl(ProgramOptions.class);
        HashSet<ValidOption> opts = new HashSet<ValidOption>();
        ProgramOptions.addMetaOption(opts, "host", 'H', "STRING", false, "localhost");
        ProgramOptions.addMetaOption(opts, "port", 'p', "STRING", false, "4848");
        ProgramOptions.addMetaOption(opts, "user", 'u', "STRING", false, "anonymous");
        ProgramOptions.addMetaOption(opts, "password", 'w', "STRING", false, null);
        ProgramOptions.addMetaOption(opts, "passwordfile", 'W', "FILE", false, null);
        ProgramOptions.addMetaOption(opts, "secure", 's', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, "terse", 't', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, "echo", 'e', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, "interactive", 'I', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, "help", '?', "BOOLEAN", false, "false");
        programOptions = Collections.unmodifiableSet(opts);
        emptyOptions = Collections.emptyMap();
    }
}

