/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.HashSet;

public class RestartDomainCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartDomainCommand.class);

    public RestartDomainCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException, CommandValidationException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        this.processProgramOptions();
        this.commandOpts = new HashSet();
        RestartDomainCommand.addOption(this.commandOpts, "help", '?', "BOOLEAN", false, "false");
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        long uptimeOldServer = this.getUptime();
        RemoteCommand cmd = new RemoteCommand("restart-domain", this.programOpts, this.env);
        cmd.executeAndReturnOutput("restart-domain");
        this.waitForRestart(uptimeOldServer);
        logger.printMessage(strings.get("restartDomain.success"));
        return 0;
    }

    private long getUptime() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand("uptime", this.programOpts, this.env);
        String up = cmd.executeAndReturnOutput("uptime");
        long up_ms = this.parseUptime(up);
        if (up_ms <= 0L) {
            throw new CommandException(strings.get("StopDomain.dasNotRunning"));
        }
        logger.printDebugMessage("server uptime: " + up_ms);
        return up_ms;
    }

    private long parseUptime(String up) {
        if (up == null || up.length() < 4) {
            return 0L;
        }
        int index = (up = up.trim()).lastIndexOf(58);
        if (index < 0) {
            return 0L;
        }
        if (up.length() - index < 3) {
            return 0L;
        }
        try {
            return Long.parseLong(up.substring(index + 2));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void waitForRestart(long uptimeOldServer) throws CommandException {
        long end = 90000L + System.currentTimeMillis();
        while (System.currentTimeMillis() < end) {
            try {
                Thread.sleep(300L);
                long up = this.getUptime();
                if (up <= 0L || up >= uptimeOldServer) continue;
                return;
            }
            catch (Exception e) {
            }
        }
        throw new CommandException(strings.get("restartDomain.noGFStart"));
    }
}

