/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.FileFilter;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class StopDomainCommand
extends CLICommand {
    private File domainsDir;
    private File domainRootDir;
    private String domainName;
    private File domainXml;
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);

    public StopDomainCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException, CommandValidationException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        this.processProgramOptions();
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        StopDomainCommand.addOption(opts, "domaindir", '\u0000', "STRING", false, null);
        StopDomainCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
    }

    protected void validate() throws CommandException, CommandValidationException {
        String domaindir;
        super.validate();
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.get(0);
        }
        if (StopDomainCommand.ok(domaindir = this.getOption("domaindir"))) {
            this.domainsDir = new File(domaindir);
            if (!this.domainsDir.isDirectory()) {
                throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
            }
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        this.getDomainRootDir();
        this.getDomainXml();
        this.domainRootDir = SmartFile.sanitize((File)this.domainRootDir);
        Integer[] ports = null;
        try {
            MiniXmlParser parser = new MiniXmlParser(this.domainXml);
            Set portsSet = parser.getAdminPorts();
            ports = portsSet.toArray(new Integer[portsSet.size()]);
        }
        catch (MiniXmlParserException ex) {
            throw new CommandValidationException(strings.get("StopDomain.parserError", new Object[]{ex}), ex);
        }
        int adminPort = ports[0];
        this.programOpts.setPort(adminPort);
        if (!DASUtils.pingDASQuietly(this.programOpts, this.env)) {
            logger.printWarning(strings.get("StopDomain.dasNotRunning"));
            return 0;
        }
        RemoteCommand cmd = new RemoteCommand("stop-domain", this.programOpts, this.env);
        cmd.executeAndReturnOutput("stop-domain");
        this.waitForDeath(adminPort);
        return 0;
    }

    private void getDomainRootDir() throws CommandValidationException {
        if (this.domainsDir == null) {
            this.domainsDir = new File(this.getSystemProperty("com.sun.aas.domainsRoot"));
        }
        if (!this.domainsDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
        }
        this.domainRootDir = this.domainName != null ? new File(this.domainsDir, this.domainName) : this.getTheOneAndOnlyDomain(this.domainsDir);
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainDir", new Object[]{this.domainRootDir}));
        }
    }

    private void getDomainXml() throws CommandValidationException {
        this.domainXml = new File(this.domainRootDir, "config/domain.xml");
        if (!this.domainXml.canRead()) {
            throw new CommandValidationException(strings.get("StopDomain.noDomainXml", new Object[]{this.domainXml}));
        }
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandValidationException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandValidationException(strings.get("noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            throw new CommandValidationException(strings.get("StopDomain.tooManyDomainDirs", new Object[]{parent}));
        }
        return files[0];
    }

    private void waitForDeath(int adminPort) throws CommandException {
        long startWait = System.currentTimeMillis();
        System.err.print(strings.get("StopDomain.WaitDASDeath") + " ");
        boolean alive = true;
        while (!this.timedOut(startWait)) {
            if (!this.pingPort(adminPort)) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                System.err.print(".");
            }
            catch (InterruptedException ex) {}
        }
        System.err.println();
        if (alive) {
            throw new CommandException(strings.get("StopDomain.DASNotDead", new Object[]{60L}));
        }
    }

    private boolean pingPort(int port) {
        try {
            String host = null;
            new Socket(host, port);
            return true;
        }
        catch (Exception ex) {
            logger.printDetailMessage(strings.get("pingPort got Exception: " + ex));
            return false;
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

