/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BtraceClientGenerator {
    public static byte[] generateBtraceClientClassData(int clientID, Collection<FlashlightProbe> probesRequiringTransformation, Class clientClazz) {
        Type classType = Type.getType(clientClazz);
        String generatedClassName = clientClazz.getName();
        generatedClassName = generatedClassName + "_BTrace_" + clientID + "_";
        generatedClassName = "com.sun.btrace.flashlight." + generatedClassName;
        generatedClassName = generatedClassName.replace('.', '/');
        int cwFlags = 3;
        ClassWriter cw = new ClassWriter(cwFlags);
        int access = 17;
        cw.visit(49, access, generatedClassName, null, "java/lang/Object", null);
        AnnotationVisitor av = cw.visitAnnotation("Lcom/sun/btrace/annotations/BTrace;", true);
        Type probeType = Type.getType(FlashlightProbe.class);
        int methodCounter = 0;
        for (FlashlightProbe probe : probesRequiringTransformation) {
            String typeDesc = "void ";
            String methodDesc = "void __" + probe.getProviderJavaMethodName() + "__" + clientID + "_" + methodCounter + "_";
            methodDesc = methodDesc + "(";
            typeDesc = typeDesc + "(";
            String delim = "";
            for (Class paramType : probe.getParamTypes()) {
                methodDesc = methodDesc + delim + paramType.getName();
                typeDesc = typeDesc + delim + paramType.getName();
                delim = ", ";
            }
            methodDesc = methodDesc + ")";
            typeDesc = typeDesc + ")";
            Method m = Method.getMethod(methodDesc);
            GeneratorAdapter gen = new GeneratorAdapter(9, m, null, null, cw);
            av = gen.visitAnnotation("Lcom/sun/btrace/annotations/OnMethod;", true);
            av.visit("clazz", "" + probe.getProviderClazz().getName());
            av.visit("method", probe.getProviderJavaMethodName());
            av.visit("type", typeDesc);
            av.visitEnd();
            gen.push(probe.getId());
            gen.loadArgArray();
            gen.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("void invokeProbe(int, Object[])"));
            gen.returnValue();
            gen.endMethod();
            ++methodCounter;
        }
        BtraceClientGenerator.generateConstructor(cw);
        cw.visitEnd();
        byte[] classData = cw.toByteArray();
        try {
            int index = generatedClassName.lastIndexOf(47);
            String rootPath = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
            String fileName = rootPath + generatedClassName.substring(index + 1) + ".class";
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(classData);
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return classData;
    }

    private static void generateConstructor(ClassWriter cw) {
        Method m = Method.getMethod("void <init> ()");
        GeneratorAdapter gen = new GeneratorAdapter(1, m, null, null, cw);
        gen.loadThis();
        gen.invokeConstructor(Type.getType(Object.class), m);
        gen.returnValue();
        gen.endMethod();
    }
}

