/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIManFileFinder;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.LocalCommand;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.commands.CommandTable;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLICommand {
    public static final int ERROR = 1;
    public static final int CONNECTION_ERROR = 2;
    public static final int INVALID_COMMAND_ERROR = 3;
    public static final int SUCCESS = 0;
    private static final CLIDescriptorsReader cliDescriptorsReader;
    private static final Set<String> unsupported;
    private static final String UNSUPPORTED_CMD_FILE_NAME = "unsupported-legacy-command-names";
    private static final CommandTable localCommands;
    private static final LocalStringsImpl strings;
    private static final Map<String, String> systemProps;
    protected static final CLILogger logger;
    protected String name;
    protected ProgramOptions programOpts;
    protected Environment env;
    protected String[] argv;
    protected Set<ValidOption> commandOpts;
    protected String operandName = "";
    protected String operandType;
    protected int operandMin;
    protected int operandMax;
    protected boolean unknownOptionsAreOperands = false;
    protected Map<String, String> options;
    protected List<String> operands;
    protected Map<String, String> passwords;

    public static CLICommand getCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException {
        CLICommand.checkUnsupportedLegacyCommand(name);
        CLICommand cmd = CLICommand.getCommandClass(name, programOpts, env);
        if (cmd != null) {
            return cmd;
        }
        try {
            if (cliDescriptorsReader.getCommand(name) != null) {
                logger.printMessage("WARNING: Using old command: " + name);
                return new LocalCommand(name, programOpts, env);
            }
        }
        catch (CommandValidationException ex) {
            // empty catch block
        }
        return new RemoteCommand(name, programOpts, env);
    }

    private static CLICommand getCommandClass(String name, ProgramOptions programOpts, Environment env) {
        try {
            Class<?> cls = (Class<?>)localCommands.get(name);
            if (cls == null) {
                cls = Class.forName(CLICommand.nameToClass(name));
            }
            Constructor<?> cons = cls.getConstructor(String.class, ProgramOptions.class, Environment.class);
            return (CLICommand)cons.newInstance(name, programOpts, env);
        }
        catch (Exception ex) {
            logger.printDebugMessage("Failed to load command class: " + ex);
            return null;
        }
    }

    private static String nameToClass(String name) {
        StringBuilder sb = new StringBuilder("com.sun.enterprise.admin.cli.optional.commands.");
        boolean makeUpper = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (makeUpper && Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            if (c == '-') {
                makeUpper = true;
                continue;
            }
            makeUpper = false;
            sb.append(c);
        }
        sb.append("Command");
        logger.printDebugMessage("Command class: " + sb.toString());
        return sb.toString();
    }

    protected CLICommand(String name, ProgramOptions programOpts, Environment env) {
        this.name = name;
        this.programOpts = programOpts;
        this.env = env;
        this.initializeLogger();
    }

    protected static void addOption(Set<ValidOption> opts, String name, char sname, String type, boolean req, String def) {
        ValidOption opt = new ValidOption(name, type, req ? 1 : 2, def);
        if (sname != '\u0000') {
            String abbr = Character.toString(sname);
            opt.setShortName(abbr);
        }
        opts.add(opt);
    }

    public int execute(String ... argv) throws CommandException, CommandValidationException {
        this.argv = argv;
        this.initializePasswords();
        this.prepare();
        this.parse();
        if (this.checkHelp()) {
            return 0;
        }
        this.validate();
        if (this.programOpts.isEcho()) {
            logger.printMessage(this.toString());
        } else if (logger.isDebug()) {
            logger.printDebugMessage(this.toString());
        }
        return this.executeCommand();
    }

    public String getName() {
        return this.name;
    }

    public Reader getManPage() {
        return CLIManFileFinder.getCommandManFile(this);
    }

    public String getUsage() {
        StringBuffer usageText = new StringBuffer();
        usageText.append("Usage: ");
        usageText.append(this.getName());
        usageText.append(" ");
        for (ValidOption opt : this.commandOpts) {
            String optName = opt.getName();
            if (opt.getType().equals("PASSWORD")) continue;
            boolean optional = opt.isValueRequired() != 1;
            String defValue = opt.getDefaultValue();
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(optName);
            if (opt.getType().equals("BOOLEAN")) {
                usageText.append("=").append("true|false");
            } else if (CLICommand.ok(defValue)) {
                usageText.append(" ").append(defValue);
            } else {
                usageText.append(" <").append(optName).append('>');
            }
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        String opname = this.operandName;
        if (!CLICommand.ok(opname)) {
            opname = "operand";
        }
        if (this.operandMax > 0) {
            if (this.operandMin == 0) {
                usageText.append("[").append(opname);
                if (this.operandMax > 1) {
                    usageText.append(" ...");
                }
                usageText.append("] ");
            } else {
                usageText.append(opname);
                if (this.operandMax > 1) {
                    usageText.append(" ...");
                }
                usageText.append(" ");
            }
        }
        return usageText.toString();
    }

    public String toString() {
        StringBuilder sb;
        block10: {
            block9: {
                sb = new StringBuilder();
                sb.append(this.name).append(' ');
                if (CLICommand.ok(this.programOpts.getHost())) {
                    sb.append("--host ").append(this.programOpts.getHost()).append(' ');
                }
                if (this.programOpts.getPort() > 0) {
                    sb.append("--port ").append(this.programOpts.getPort()).append(' ');
                }
                if (CLICommand.ok(this.programOpts.getUser())) {
                    sb.append("--user ").append(this.programOpts.getUser()).append(' ');
                }
                if (CLICommand.ok(this.programOpts.getPasswordFile())) {
                    sb.append("--passwordfile ").append(this.programOpts.getPasswordFile()).append(' ');
                }
                if (this.programOpts.isSecure()) {
                    sb.append("--secure ");
                }
                sb.append("--interactive=").append(Boolean.toString(this.programOpts.isInteractive())).append(' ');
                sb.append("--echo=").append(Boolean.toString(this.programOpts.isEcho())).append(' ');
                sb.append("--terse=").append(Boolean.toString(this.programOpts.isTerse())).append(' ');
                if (this.options == null || this.operands == null) break block9;
                Set<String> optionKeys = this.options.keySet();
                for (String key : optionKeys) {
                    String value = this.options.get(key);
                    sb.append("--").append(key);
                    if (CLICommand.ok(value)) {
                        sb.append('=').append(value);
                    }
                    sb.append(' ');
                }
                for (String o : this.operands) {
                    sb.append((Object)o).append(' ');
                }
                break block10;
            }
            if (this.argv == null) break block10;
            for (String arg : this.argv) {
                sb.append(arg).append(' ');
            }
        }
        return sb.toString();
    }

    protected void processProgramOptions() throws CommandException, CommandValidationException {
        if (!this.programOpts.isOptionsSet()) {
            Parser rcp = new Parser(this.argv, 0, ProgramOptions.getValidOptions(), true);
            Map<String, String> params = rcp.getOptions();
            List<String> operands = rcp.getOperands();
            this.argv = operands.toArray(new String[operands.size()]);
            if (params.size() > 0) {
                this.programOpts.updateOptions(params);
                this.initializeLogger();
                this.initializePasswords();
                Set<String> names = params.keySet();
                Object[] na = names.toArray(new String[names.size()]);
                System.out.println("Deprecated syntax: " + this.name + ", Options: " + Arrays.toString(na));
            }
        }
    }

    protected void initializeLogger() {
        if (this.programOpts.isTerse()) {
            logger.setOutputLevel(Level.INFO);
        } else {
            logger.setOutputLevel(Level.FINE);
        }
    }

    protected void initializePasswords() throws CommandException {
        this.passwords = new HashMap<String, String>();
        String pwfile = this.programOpts.getPasswordFile();
        if (CLICommand.ok(pwfile)) {
            this.passwords = CLIUtil.readPasswordFileOptions(pwfile, true);
            logger.printDebugMessage("Passwords from password file " + this.passwords);
            String password = this.passwords.get("AS_ADMIN_PASSWORD");
            if (CLICommand.ok(password)) {
                this.programOpts.setPassword(password);
            }
        }
    }

    protected abstract void prepare() throws CommandException, CommandValidationException;

    protected void parse() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp()) {
            this.options = new HashMap<String, String>();
            this.options.put("help", "true");
            this.operands = Collections.emptyList();
        } else {
            Parser rcp = new Parser(this.argv, 1, this.commandOpts, this.unknownOptionsAreOperands);
            this.options = rcp.getOptions();
            this.operands = rcp.getOperands();
        }
        logger.printDebugMessage("params: " + this.options);
        logger.printDebugMessage("operands: " + this.operands);
    }

    protected void validate() throws CommandException, CommandValidationException {
        Console cons = this.programOpts.isInteractive() ? System.console() : null;
        boolean missingOption = false;
        for (ValidOption opt : this.commandOpts) {
            if (opt.isValueRequired() != 1 || opt.getType().equals("PASSWORD")) continue;
            if (this.getOption(opt.getName()) == null && cons != null && !missingOption) {
                cons.printf("%s ", strings.get("optionPrompt", new Object[]{opt.getName()}));
                String val = cons.readLine();
                if (CLICommand.ok(val)) {
                    this.options.put(opt.getName(), val);
                }
            }
            if (this.getOption(opt.getName()) != null) continue;
            missingOption = true;
            logger.printMessage(strings.get("missingOption", new Object[]{"--" + opt.getName()}));
        }
        if (missingOption) {
            throw new CommandValidationException(strings.get("missingOptions", new Object[]{this.name}));
        }
        if (this.operands.size() < this.operandMin && cons != null) {
            cons.printf("%s ", strings.get("operandPrompt", new Object[]{this.operandName}));
            String val = cons.readLine();
            if (CLICommand.ok(val)) {
                this.operands = new ArrayList<String>();
                this.operands.add(val);
            }
        }
        if (this.operands.size() < this.operandMin) {
            throw new CommandValidationException(strings.get("notEnoughOperands", new Object[]{this.name, this.operandType}));
        }
        if (this.operands.size() > this.operandMax) {
            if (this.operandMax == 0) {
                throw new CommandValidationException(strings.get("noOperandsAllowed", new Object[]{this.name}));
            }
            if (this.operandMax == 1) {
                throw new CommandValidationException(strings.get("tooManyOperands1", new Object[]{this.name}));
            }
            throw new CommandValidationException(strings.get("tooManyOperands", new Object[]{this.name, this.operandMax}));
        }
        this.initializeCommandPassword();
    }

    protected boolean checkHelp() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp() || this.getBooleanOption("help")) {
            Reader r = this.getManPage();
            if (r == null) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}));
            }
            BufferedReader br = new BufferedReader(r);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioex) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}), ioex);
            }
            return true;
        }
        return false;
    }

    protected abstract int executeCommand() throws CommandException, CommandValidationException;

    private void initializeCommandPassword() throws CommandException, CommandValidationException {
        for (ValidOption opt : this.commandOpts) {
            if (!opt.getType().equals("PASSWORD")) continue;
            String pwdname = opt.getName();
            String pwd = this.getPassword(opt, null, true);
            String description = opt.getDefaultValue();
            if (!CLICommand.ok(description)) {
                description = pwdname;
            }
            if (pwd == null) {
                if (opt.isValueRequired() != 1) continue;
                throw new CommandValidationException(strings.get("missingPassword", new Object[]{this.name, description}));
            }
            this.options.put(pwdname, pwd);
        }
    }

    protected String getPassword(ValidOption opt, String defaultPassword, boolean create) throws CommandValidationException {
        String passwordName = opt.getName();
        String password = this.passwords.get(passwordName);
        if (CLICommand.ok(password)) {
            return password;
        }
        if (opt.isValueRequired() != 1) {
            return null;
        }
        if (!this.programOpts.isInteractive()) {
            return null;
        }
        String description = opt.getDefaultValue();
        String newprompt = CLICommand.ok(description) ? (defaultPassword != null ? strings.get("NewPasswordDescriptionDefaultPrompt", new Object[]{description}) : strings.get("NewPasswordDescriptionPrompt", new Object[]{description})) : (defaultPassword != null ? strings.get("NewPasswordDefaultPrompt", new Object[]{passwordName}) : strings.get("NewPasswordPrompt", new Object[]{passwordName}));
        String newpassword = this.readPassword(newprompt);
        if (defaultPassword != null) {
            if (newpassword == null) {
                newpassword = "";
            }
            if (newpassword.length() == 0) {
                newpassword = defaultPassword;
                this.passwords.put(passwordName, newpassword);
                return newpassword;
            }
        }
        if (!create) {
            this.passwords.put(passwordName, newpassword);
            return newpassword;
        }
        if (!this.isPasswordValid(newpassword)) {
            throw new CommandValidationException(strings.get("PasswordLimit", new Object[]{passwordName}));
        }
        String confirmationPrompt = CLICommand.ok(description) ? strings.get("NewPasswordDescriptionConfirmationPrompt", new Object[]{description}) : strings.get("NewPasswordConfirmationPrompt", new Object[]{passwordName});
        String newpasswordAgain = this.readPassword(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", new Object[]{passwordName}));
        }
        this.passwords.put(passwordName, newpassword);
        return newpassword;
    }

    protected String readPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s ", prompt);
            password = new String(pc);
        }
        return password;
    }

    protected boolean isPasswordValid(String passwd) {
        return passwd.length() >= 8;
    }

    protected String getOption(String name) {
        String val = this.options.get(name);
        if (val == null) {
            val = this.env.getStringOption(name);
        }
        return val;
    }

    protected boolean getBooleanOption(String name) {
        String val = this.getOption(name);
        return val != null && Boolean.parseBoolean(val);
    }

    protected String getSystemProperty(String name) {
        return systemProps.get(name);
    }

    private static void checkUnsupportedLegacyCommand(String cmd) throws CommandException {
        for (String c : unsupported) {
            if (!c.equals(cmd)) continue;
            throw new CommandException("Previously supported command: " + cmd + " is not supported for this release.");
        }
    }

    static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void file2Set(String file, Set<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = CLICommand.class.getClassLoader().getResourceAsStream(file);
            if (is == null) {
                return;
            }
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        localCommands = new CommandTable();
        strings = new LocalStringsImpl(CLICommand.class);
        systemProps = Collections.unmodifiableMap(new ASenvPropertyReader().getProps());
        logger = CLILogger.getInstance();
        cliDescriptorsReader = CLIDescriptorsReader.getInstance();
        cliDescriptorsReader.setSerializeDescriptorsProperty(1);
        HashSet<String> unsup = new HashSet<String>();
        CLICommand.file2Set(UNSUPPORTED_CMD_FILE_NAME, unsup);
        unsupported = Collections.unmodifiableSet(unsup);
    }
}

