/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FileFilter;

public abstract class LocalDomainCommand
extends CLICommand {
    protected File domainsDir;
    protected File domainRootDir;
    protected String domainName;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalDomainCommand.class);

    protected LocalDomainCommand(String name, ProgramOptions programOpts, Environment env) {
        super(name, programOpts, env);
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        this.initDomain();
    }

    protected void initDomain() throws CommandValidationException {
        String domaindir;
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.get(0);
        }
        if (LocalDomainCommand.ok(domaindir = this.getOption("domaindir"))) {
            this.domainsDir = new File(domaindir);
            if (!this.domainsDir.isDirectory()) {
                throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
            }
        }
        if (this.domainsDir == null) {
            this.domainsDir = new File(this.getSystemProperty("com.sun.aas.domainsRoot"));
        }
        if (!this.domainsDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
        }
        if (this.domainName != null) {
            this.domainRootDir = new File(this.domainsDir, this.domainName);
        } else {
            this.domainRootDir = this.getTheOneAndOnlyDomain(this.domainsDir);
            this.domainName = this.domainRootDir.getName();
        }
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainDir", new Object[]{this.domainRootDir}));
        }
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandValidationException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandValidationException(strings.get("noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            throw new CommandValidationException(strings.get("StopDomain.tooManyDomainDirs", new Object[]{parent}));
        }
        return files[0];
    }

    protected File getDomainXml() throws CommandValidationException {
        File domainXml = new File(this.domainRootDir, "config/domain.xml");
        if (!domainXml.canRead()) {
            throw new CommandValidationException(strings.get("StopDomain.noDomainXml", new Object[]{domainXml}));
        }
        return domainXml;
    }

    protected File getMasterPasswordFile() {
        File mp = new File(this.domainRootDir, "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    protected File getJKS() {
        File mp = new File(this.domainRootDir, "config/keystore.jks");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }
}

