/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.bootstrap;

import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class StartupContext {
    final File root;
    final File userDir;
    final Properties args;
    final long timeZero;
    public static final String TIME_ZERO_NAME = "__time_zero";
    public static final String ARGS_PROP = "hk2.startup.context.args";
    public static final String ORIGINAL_CP = "-startup-classpath";
    public static final String ORIGINAL_CN = "-startup-classname";
    public static final String ORIGINAL_ARGS = "-startup-args";
    public static final String ARG_SEP = ",,,";
    public static final String ROOT_PROP = "hk2.startup.context.root";
    public static final String STARTUP_MODULE_NAME = "hk2.startup.context.mainModule";
    public static final String STARTUP_MODULESTARTUP_NAME = "hk2.startup.context.moduleStartup";

    public StartupContext() {
        this.userDir = this.root = new File(System.getProperty("user.dir"));
        this.timeZero = System.currentTimeMillis();
        this.args = new Properties();
    }

    public StartupContext(File root, String[] args) {
        this(root, null, args);
    }

    public StartupContext(File root, File userDir, String[] args) {
        this.root = this.absolutize(root);
        this.userDir = userDir != null ? this.absolutize(userDir) : null;
        this.args = ArgumentManager.argsToMap(args);
        this.timeZero = System.currentTimeMillis();
    }

    public StartupContext(File root, Properties args) {
        this(root, null, args);
    }

    public StartupContext(File root, File userDir, Properties args) {
        this.root = root;
        this.args = args;
        this.userDir = userDir;
        this.timeZero = args.containsKey(TIME_ZERO_NAME) ? Long.decode(args.getProperty(TIME_ZERO_NAME)) : System.currentTimeMillis();
    }

    public File getRootDirectory() {
        return this.root;
    }

    public File getUserDirectory() {
        return this.userDir;
    }

    public Properties getArguments() {
        return this.args;
    }

    public String[] getOriginalArguments() {
        String s = this.args.getProperty(ORIGINAL_ARGS);
        if (s == null) {
            return new String[0];
        }
        StringTokenizer args = new StringTokenizer(s, ARG_SEP, false);
        ArrayList<String> result = new ArrayList<String>();
        while (args.hasMoreTokens()) {
            result.add(args.nextToken());
        }
        return result.toArray(new String[0]);
    }

    public String getStartupModuleName() {
        return (String)String.class.cast(this.args.get(STARTUP_MODULE_NAME));
    }

    public String getPlatformMainServiceName() {
        return (String)String.class.cast(this.args.get(STARTUP_MODULESTARTUP_NAME));
    }

    public long getCreationTime() {
        return this.timeZero;
    }

    private File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }
}

