/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.AsadminMain;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedHashSet;

public class MultimodeCommand
extends CLICommand {
    private boolean printPrompt;
    private String encoding;
    private File file;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MultimodeCommand.class);

    public MultimodeCommand(String name, ProgramOptions programOpts, Environment env) {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        MultimodeCommand.addOption(opts, "file", 'f', "FILE", false, null);
        MultimodeCommand.addOption(opts, "printprompt", '\u0000', "BOOLEAN", false, "true");
        MultimodeCommand.addOption(opts, "encoding", '\u0000', "STRING", false, null);
        MultimodeCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        String pp = this.getOption("printprompt");
        this.printPrompt = pp != null ? Boolean.parseBoolean(pp) : this.programOpts.isInteractive();
        this.encoding = this.getOption("encoding");
        String fname = this.getOption("file");
        if (fname != null) {
            this.file = new File(fname);
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        BufferedReader reader = null;
        try {
            if (this.file == null) {
                System.out.println(strings.get("multimodeIntro"));
                if (this.encoding != null) {
                    reader = new BufferedReader(new InputStreamReader(System.in, this.encoding));
                }
                reader = new BufferedReader(new InputStreamReader(System.in));
            } else {
                this.printPrompt = false;
                if (!this.file.canRead()) {
                    throw new CommandException("File: " + this.file + " can not be read");
                }
                reader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)) : new BufferedReader(new FileReader(this.file));
            }
            int n = this.executeCommands(reader);
            return n;
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private int executeCommands(BufferedReader reader) throws CommandException, CommandValidationException, IOException {
        String line = null;
        int rc = 0;
        this.programOpts.toEnvironment(this.env);
        while (true) {
            String command;
            if (this.printPrompt) {
                System.out.print("asadmin> ");
                System.out.flush();
            }
            if ((line = reader.readLine()) == null) {
                if (!this.printPrompt) break;
                System.out.println();
                break;
            }
            String[] args = this.getArgs(line);
            if (args.length == 0 || (command = args[0]).length() == 0) continue;
            if (command.equals("exit") || command.equals("quit")) break;
            CLICommand cmd = null;
            try {
                ProgramOptions po = new ProgramOptions(this.env);
                po.setProgramArguments(this.programOpts.getProgramArguments());
                po.setClassPath(this.programOpts.getClassPath());
                po.setClassName(this.programOpts.getClassName());
                cmd = CLICommand.getCommand(command, po, this.env);
                rc = cmd.execute(args);
            }
            catch (CommandValidationException cve) {
                logger.printError(cve.getMessage());
                logger.printError(cmd.getUsage());
                rc = 1;
            }
            catch (CommandException ce) {
                logger.printError(ce.getMessage());
                rc = 1;
            }
            switch (rc) {
                case 0: {
                    if (this.programOpts.isTerse()) break;
                    logger.printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
                    break;
                }
                case 1: {
                    logger.printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                    break;
                }
                case 3: {
                    logger.printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                    break;
                }
                case 2: {
                    logger.printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                }
            }
            AsadminMain.writeCommandToDebugLog(args, rc);
        }
        return rc;
    }

    private String[] getArgs(String line) {
        String regex = "\\s+";
        String[] parts = line.trim().split(regex);
        return parts;
    }
}

