/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.AuthenticationException;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteException;
import com.sun.enterprise.admin.cli.remote.RemoteResponseManager;
import com.sun.enterprise.admin.cli.remote.RemoteSuccessException;
import com.sun.enterprise.admin.cli.util.AuthenticationInfo;
import com.sun.enterprise.admin.cli.util.HttpConnectorAddress;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.GFBase64Encoder;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.FileUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.admin.Payload;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteCommand.class);
    private static final String QUERY_STRING_INTRODUCER = "?";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ADMIN_URI_PATH = "/__asadmin/";
    private static final String COMMAND_NAME_REGEXP = "^[a-zA-Z][-a-zA-Z0-9_]*$";
    private String responseFormatType = "hk2-agent";
    private OutputStream userOut;
    private boolean returnOutput = false;
    private String output;
    private boolean doUpload = false;
    private boolean addedUploadOption = false;
    private Payload.Outbound outboundPayload;
    private static final String FILE_PAYLOAD_MIME_TYPE = "application/octet-stream";

    public RemoteCommand(String name, ProgramOptions po, Environment env) throws CommandException {
        super(name, po, env);
        if (!name.matches(COMMAND_NAME_REGEXP)) {
            throw new CommandException("Illegal command name: " + name);
        }
    }

    @Override
    protected void prepare() throws CommandException {
        try {
            this.processProgramOptions();
            this.initializeAuth();
            if (this.programOpts.isHelp()) {
                this.commandOpts = new HashSet();
                ValidOption opt = new ValidOption("help", "BOOLEAN", 2, "false");
                opt.setShortName(QUERY_STRING_INTRODUCER);
                this.commandOpts.add(opt);
                return;
            }
            try {
                this.fetchCommandMetadata();
            }
            catch (AuthenticationException ex) {
                if (this.updateAuthentication()) {
                    this.fetchCommandMetadata();
                }
                throw ex;
            }
            if (this.commandOpts == null) {
                throw new CommandException("Unknown command: " + this.name);
            }
            RemoteCommand.addOption(this.commandOpts, "help", '?', "BOOLEAN", false, "false");
        }
        catch (CommandException cex) {
            throw cex;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    @Override
    protected boolean checkHelp() throws CommandException, CommandValidationException {
        return false;
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        block12: {
            try {
                this.initializeDoUpload();
                if (this.doUpload) {
                    this.outboundPayload = PayloadImpl.Outbound.newInstance();
                }
                StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(this.name).append(QUERY_STRING_INTRODUCER);
                GFBase64Encoder encoder = new GFBase64Encoder();
                for (Map.Entry param : this.options.entrySet()) {
                    String paramName = (String)param.getKey();
                    String paramValue = (String)param.getValue();
                    ValidOption opt = this.getValidOption(paramName);
                    if (opt == null) {
                        String msg = strings.get("unknownOption", new Object[]{this.name, paramName});
                        throw new CommandException(msg);
                    }
                    if (opt.getType().equals("FILE")) {
                        this.addFileOption(uriString, paramName, paramValue);
                        continue;
                    }
                    if (opt.getType().equals("PASSWORD")) {
                        this.addStringOption(uriString, paramName, encoder.encode(paramValue.getBytes()));
                        continue;
                    }
                    this.addStringOption(uriString, paramName, paramValue);
                }
                for (String operand : this.operands) {
                    if (this.operandType.equals("FILE")) {
                        this.addFileOption(uriString, "DEFAULT", operand);
                        continue;
                    }
                    this.addStringOption(uriString, "DEFAULT", operand);
                }
                uriString.setLength(uriString.length() - 1);
                try {
                    this.executeRemoteCommand(uriString.toString());
                }
                catch (AuthenticationException ex) {
                    if (this.updateAuthentication()) {
                        this.executeRemoteCommand(uriString.toString());
                        break block12;
                    }
                    throw ex;
                }
            }
            catch (IOException ioex) {
                throw new CommandException("I/O Error", ioex);
            }
        }
        return 0;
    }

    private void executeRemoteCommand(String uri) throws CommandException {
        this.doHttpCommand(uri, this.chooseRequestMethod(), new HttpCommand(){

            public void doCommand(HttpURLConnection urlConnection) throws CommandException, IOException {
                if (RemoteCommand.this.doUpload) {
                    urlConnection.setChunkedStreamingMode(0);
                    urlConnection.setRequestProperty("Content-Type", RemoteCommand.this.outboundPayload.getContentType());
                }
                urlConnection.connect();
                if (RemoteCommand.this.doUpload) {
                    RemoteCommand.this.outboundPayload.writeTo(urlConnection.getOutputStream());
                    RemoteCommand.this.outboundPayload = null;
                }
                InputStream in = urlConnection.getInputStream();
                String responseContentType = urlConnection.getContentType();
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)responseContentType, (InputStream)in);
                boolean isReportProcessed = false;
                PayloadFilesManager.Perm downloadedFilesMgr = new PayloadFilesManager.Perm();
                Iterator partIt = inboundPayload.parts();
                while (partIt.hasNext()) {
                    if (!isReportProcessed) {
                        RemoteCommand.this.handleResponse(RemoteCommand.this.options, ((Payload.Part)partIt.next()).getInputStream(), urlConnection.getResponseCode(), RemoteCommand.this.userOut);
                        isReportProcessed = true;
                        continue;
                    }
                    RemoteCommand.this.processDataPart((PayloadFilesManager)downloadedFilesMgr, (Payload.Part)partIt.next());
                }
            }
        });
    }

    public String executeAndReturnOutput(String ... args) throws CommandException, CommandValidationException {
        this.returnOutput = true;
        this.execute(args);
        return this.output;
    }

    private void doHttpCommand(String uriString, String httpMethod, HttpCommand cmd) throws CommandException {
        HttpURLConnection urlConnection = null;
        try {
            HttpConnectorAddress url = new HttpConnectorAddress(this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure());
            logger.printDebugMessage("URI: " + uriString);
            logger.printDebugMessage("URL: " + url.toString());
            logger.printDebugMessage("URL: " + url.toURL(uriString.toString()).toString());
            url.setAuthenticationInfo(new AuthenticationInfo(this.programOpts.getUser(), this.programOpts.getPassword()));
            urlConnection = (HttpURLConnection)url.openConnection(uriString.toString());
            urlConnection.setRequestProperty("User-Agent", this.responseFormatType);
            urlConnection.setRequestProperty("Authorization", url.getBasicAuthString());
            urlConnection.setRequestMethod(httpMethod);
            cmd.doCommand(urlConnection);
        }
        catch (ConnectException ce) {
            String msg = strings.get("ConnectException", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""});
            throw new CommandException(msg, ce);
        }
        catch (UnknownHostException he) {
            String msg = strings.get("UnknownHostException", new Object[]{this.programOpts.getHost()});
            throw new CommandException(msg, he);
        }
        catch (SocketException se) {
            try {
                boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.programOpts.getHost(), (int)this.programOpts.getPort());
                if (serverAppearsSecure != this.programOpts.isSecure()) {
                    String msg = strings.get("ServerMaybeSecure", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""});
                    logger.printError(msg);
                    throw new CommandException(se);
                }
            }
            catch (IOException io) {
                logger.printExceptionStackTrace(io);
                throw new CommandException(io);
            }
        }
        catch (IOException e) {
            String msg = "Unknown I/O Error";
            if (urlConnection != null) {
                try {
                    int rc = urlConnection.getResponseCode();
                    if (401 == rc) {
                        msg = strings.get("InvalidCredentials", new Object[]{this.programOpts.getUser()});
                        throw new AuthenticationException(msg);
                    }
                    msg = "Status: " + rc;
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            throw new CommandException(msg, e);
        }
        catch (Exception e) {
            logger.printExceptionStackTrace(e);
            throw new CommandException(e);
        }
    }

    public String getCommandName() {
        return this.name;
    }

    @Override
    public Reader getManPage() {
        try {
            String manpage = this.executeAndReturnOutput(this.name, "--help");
            return new StringReader(manpage);
        }
        catch (CommandException cex) {
        }
        catch (CommandValidationException commandValidationException) {
            // empty catch block
        }
        return super.getManPage();
    }

    private void processDataPart(PayloadFilesManager downloadedFilesMgr, Payload.Part part) throws IOException {
        Properties partProps = part.getProperties();
        String dataRequestType = partProps.getProperty("data-request-type");
        if (dataRequestType.equals("file-xfer")) {
            downloadedFilesMgr.extractFile(part);
        }
    }

    private StringBuilder addStringOption(StringBuilder uriString, String name, String option) {
        try {
            String encodedOption = URLEncoder.encode(option, "UTF-8");
            uriString.append(name).append('=').append(encodedOption).append(QUERY_STRING_SEPARATOR);
        }
        catch (UnsupportedEncodingException e) {
            logger.printError("Error encoding value for: " + name + ", Value:" + option + ", parameter value will be ignored");
        }
        return uriString;
    }

    private StringBuilder addFileOption(StringBuilder uriString, String optionName, String filename) throws IOException {
        File f = SmartFile.sanitize((File)new File(filename));
        logger.printDebugMessage("FILE PARAM: " + optionName + " = " + f);
        if (this.doUpload) {
            this.outboundPayload.attachFile(FILE_PAYLOAD_MIME_TYPE, f.toURI(), optionName, null, f);
        }
        if (f != null) {
            String pathToPass = this.doUpload ? f.getName() : f.getPath();
            this.addStringOption(uriString, optionName, pathToPass);
        }
        return uriString;
    }

    private String chooseRequestMethod() {
        if (this.doUpload) {
            return "POST";
        }
        return "GET";
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code, OutputStream userOut) throws IOException, CommandException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            FileUtils.copyStream((InputStream)in, (OutputStream)userOut);
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code) throws IOException, CommandException {
        RemoteResponseManager rrm = null;
        try {
            rrm = new RemoteResponseManager(in, code);
            rrm.process();
        }
        catch (RemoteSuccessException rse) {
            if (this.returnOutput) {
                this.output = rse.getMessage();
            } else {
                logger.printMessage(rse.getMessage());
            }
            return;
        }
        catch (RemoteException rfe) {
            if (rfe.getRemoteCause().indexOf("CommandNotFoundException") > 0) {
                throw new CommandException(rfe.getMessage(), new InvalidCommandException());
            }
            throw new CommandException("remote failure: " + rfe.getMessage(), rfe);
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    protected void fetchCommandMetadata() throws CommandException {
        StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(this.name).append(QUERY_STRING_INTRODUCER);
        this.addStringOption(uriString, "Xhelp", "true");
        uriString.setLength(uriString.length() - 1);
        this.doHttpCommand(uriString.toString(), "GET", new HttpCommand(){

            public void doCommand(HttpURLConnection urlConnection) throws CommandException, IOException {
                urlConnection.setRequestProperty("User-Agent", "metadata");
                urlConnection.connect();
                InputStream in = urlConnection.getInputStream();
                String responseContentType = urlConnection.getContentType();
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)responseContentType, (InputStream)in);
                boolean isReportProcessed = false;
                Iterator partIt = inboundPayload.parts();
                while (partIt.hasNext()) {
                    if (!isReportProcessed) {
                        RemoteCommand.this.commandOpts = RemoteCommand.this.parseMetadata(((Payload.Part)partIt.next()).getInputStream());
                        isReportProcessed = true;
                        continue;
                    }
                    partIt.next();
                }
            }
        });
    }

    private Set<ValidOption> parseMetadata(InputStream in) {
        LinkedHashSet<ValidOption> valid = new LinkedHashSet<ValidOption>();
        boolean sawFile = false;
        try {
            NamedNodeMap attrs;
            Node n;
            int i;
            DocumentBuilder d = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = d.parse(in);
            NodeList cmd = doc.getElementsByTagName("command");
            Node cmdnode = cmd.item(0);
            if (cmdnode == null) {
                return null;
            }
            NamedNodeMap cmdattrs = cmdnode.getAttributes();
            String dashOk = RemoteCommand.getAttr(cmdattrs, "unknown-options-are-operands");
            if (dashOk != null) {
                this.unknownOptionsAreOperands = Boolean.parseBoolean(dashOk);
            }
            NodeList opts = doc.getElementsByTagName("option");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                ValidOption opt = new ValidOption(RemoteCommand.getAttr(attrs, "name"), RemoteCommand.getAttr(attrs, "type"), Boolean.parseBoolean(RemoteCommand.getAttr(attrs, "optional")) ? 2 : 1, RemoteCommand.getAttr(attrs, "default"));
                opt.setShortName(RemoteCommand.getAttr(attrs, "short"));
                if (opt.getType().equals("PASSWORD") && RemoteCommand.getAttr(attrs, "description") != null) {
                    opt.setDefaultValue(RemoteCommand.getAttr(attrs, "description"));
                }
                valid.add(opt);
                if (!opt.getType().equals("FILE")) continue;
                sawFile = true;
            }
            opts = doc.getElementsByTagName("operand");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                this.operandName = RemoteCommand.getAttr(attrs, "name");
                this.operandType = RemoteCommand.getAttr(attrs, "type");
                this.operandMin = Integer.parseInt(RemoteCommand.getAttr(attrs, "min"));
                String max = RemoteCommand.getAttr(attrs, "max");
                this.operandMax = max.equals("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(max);
                if (!this.operandType.equals("FILE")) continue;
                sawFile = true;
            }
            if (sawFile) {
                valid.add(new ValidOption("upload", "BOOLEAN", 2, "false"));
                this.addedUploadOption = true;
            }
        }
        catch (ParserConfigurationException pex) {
            return null;
        }
        catch (SAXException sex) {
            return null;
        }
        catch (IOException ioex) {
            return null;
        }
        return valid;
    }

    private static String getAttr(NamedNodeMap attrs, String name) {
        Node n = attrs.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private void initializeDoUpload() {
        boolean sawFile = false;
        boolean sawDirectory = false;
        for (Map.Entry param : this.options.entrySet()) {
            String paramName = (String)param.getKey();
            ValidOption opt = this.getValidOption(paramName);
            if (opt == null || !opt.getType().equals("FILE")) continue;
            sawFile = true;
            String filename = (String)param.getValue();
            File file = new File(filename);
            if (!file.isDirectory()) continue;
            sawDirectory = true;
        }
        if (this.operandType != null && this.operandType.equals("FILE")) {
            for (String filename : this.operands) {
                sawFile = true;
                File file = new File(filename);
                if (!file.isDirectory()) continue;
                sawDirectory = true;
            }
        }
        if (sawFile && !sawDirectory) {
            String upString = this.getOption("upload");
            this.doUpload = RemoteCommand.ok(upString) ? Boolean.parseBoolean(upString) : true;
        }
        if (this.addedUploadOption) {
            this.options.remove("upload");
        }
    }

    private ValidOption getValidOption(String name) {
        for (ValidOption opt : this.commandOpts) {
            if (!opt.getName().equals(name)) continue;
            return opt;
        }
        return null;
    }

    protected boolean updateAuthentication() {
        Console cons;
        if (this.programOpts.isInteractive() && (cons = System.console()) != null) {
            cons.printf("%s ", strings.get("AdminUserPrompt", new Object[]{this.programOpts.getUser()}));
            String user = cons.readLine();
            if (user == null) {
                return false;
            }
            String password = this.readPassword(strings.get("AdminPasswordPrompt"));
            if (password == null) {
                return false;
            }
            if (user.length() > 0) {
                this.programOpts.setUser(user);
            }
            this.programOpts.setPassword(password);
            return true;
        }
        return false;
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
            li = store.read(this.programOpts.getHost(), this.programOpts.getPort());
        }
        catch (StoreException se) {
            logger.printDebugMessage("Login info could not be read from ~/.asadminpass file");
        }
        if (this.programOpts.getUser() == null && li != null) {
            this.programOpts.setUser(li.getUser());
            logger.printDebugMessage("Getting user name from ~/.asadminpass: " + this.programOpts.getUser());
        }
        if (this.programOpts.getPassword() == null && li != null) {
            this.programOpts.setPassword(li.getPassword());
            logger.printDebugMessage("Getting password from ~/.asadminpass");
        }
    }

    static interface HttpCommand {
        public void doCommand(HttpURLConnection var1) throws CommandException, IOException;
    }
}

