/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThreadImpl;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCache {
    public static final String DEFAULT_SERVLET_NAME = "default";
    private final ConcurrentHashMap<String, FileCacheEntry> fileCache = new ConcurrentHashMap();
    protected static final ByteBuffer nullByteBuffer = ByteBuffer.allocate(0);
    protected static final ByteBuffer connectionCloseBB = ByteBuffer.wrap("Connection: close\r\n\r\n".getBytes());
    protected static final ByteBuffer connectionKaBB = ByteBuffer.wrap("Connection: keep-alive\r\n\r\n".getBytes());
    private static final String NEWLINE = "\r\n";
    public static final String OK = "HTTP/1.1 200 OK\r\n";
    private int port = 8080;
    private ScheduledThreadPoolExecutor cacheResourcesThread = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new WorkerThreadImpl(new ThreadGroup("Grizzly"), r);
        }
    });
    private ConcurrentLinkedQueue<FileCacheEntry> cacheManager;
    private int secondsMaxAge = -1;
    private int maxCacheEntries = 1024;
    private long minEntrySize = Long.MIN_VALUE;
    private long maxEntrySize = Long.MAX_VALUE;
    private long maxLargeFileCacheSize = Long.MAX_VALUE;
    private long maxSmallFileCacheSize = 0x100000L;
    private static long mappedMemorySize = 0L;
    private static long heapSize = 0L;
    private boolean isEnabled = true;
    private boolean isLargeFileCacheEnabled = true;
    private static boolean isMonitoringEnabled = false;
    private int openCacheEntries = 0;
    private int maxOpenCacheEntries = 0;
    private long maxHeapCacheSize = 0L;
    private long maxMappedMemory = 0L;
    private int countHits = 0;
    private int countMisses = 0;
    private int countCacheHits;
    private int countCacheMisses;
    private int countMappedHits;
    private int countMappedMisses;
    private int headerBBSize = 4096;

    public synchronized void add(String mappedServlet, String baseDir, String requestURI, MimeHeaders headers, boolean xPoweredBy) {
        if (requestURI == null || this.fileCache.get(requestURI) != null) {
            return;
        }
        if (this.fileCache.size() > this.maxCacheEntries) {
            return;
        }
        if (mappedServlet.equals(DEFAULT_SERVLET_NAME)) {
            FileCacheEntry entry;
            File file = new File(baseDir + requestURI);
            ByteBuffer bb = this.mapFile(file);
            if (bb == null) {
                bb = nullByteBuffer;
            }
            if ((entry = this.cacheManager.poll()) == null) {
                entry = new FileCacheEntry();
            }
            entry.bb = bb;
            entry.requestURI = requestURI;
            if (bb != nullByteBuffer) {
                entry.lastModified = headers.getHeader("Last-Modified");
                entry.contentType = headers.getHeader("content-type");
                entry.xPoweredBy = xPoweredBy;
                entry.isInHeap = file.length() < this.minEntrySize;
                entry.date = headers.getHeader("Date");
                entry.Etag = headers.getHeader("Etag");
                this.configHeaders(entry);
                if (isMonitoringEnabled) {
                    ++this.openCacheEntries;
                    if (this.openCacheEntries > this.maxOpenCacheEntries) {
                        this.maxOpenCacheEntries = this.openCacheEntries;
                    }
                    if (heapSize > this.maxHeapCacheSize) {
                        this.maxHeapCacheSize = heapSize;
                    }
                    if (mappedMemorySize > this.maxMappedMemory) {
                        this.maxMappedMemory = mappedMemorySize;
                    }
                }
                if (this.secondsMaxAge > 0) {
                    entry.future = this.cacheResourcesThread.schedule(entry, (long)this.secondsMaxAge, TimeUnit.SECONDS);
                }
            }
            this.fileCache.put(requestURI, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer mapFile(File file) {
        MappedByteBuffer mappedByteBuffer;
        FileChannel fileChannel = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            fileChannel = stream.getChannel();
            long size = fileChannel.size();
            if (!this.isLargeFileCacheEnabled) {
                if (size > this.minEntrySize) {
                    ByteBuffer byteBuffer = null;
                    return byteBuffer;
                }
            } else if (size > this.maxEntrySize) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            if (size > this.minEntrySize) {
                mappedMemorySize += size;
            } else {
                heapSize += size;
            }
            if (mappedMemorySize > this.maxLargeFileCacheSize) {
                mappedMemorySize -= size;
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            if (heapSize > this.maxSmallFileCacheSize) {
                heapSize -= size;
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            MappedByteBuffer bb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            if (size < this.minEntrySize) {
                bb.load();
            }
            mappedByteBuffer = bb;
        }
        catch (IOException ioe) {
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {}
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException ioe) {}
            }
        }
        return mappedByteBuffer;
    }

    protected final FileCacheEntry map(byte[] requestBytes, int start, int length) {
        String uri = "";
        FileCacheEntry entry = null;
        if (this.fileCache.size() != 0) {
            uri = new String(requestBytes, start, length);
            entry = this.fileCache.get(uri);
            if (isMonitoringEnabled) {
                if (entry != null && entry.bb != null && entry.bb != nullByteBuffer) {
                    if (entry.isInHeap) {
                        this.countInfoHit();
                    } else {
                        this.countContentHit();
                    }
                    this.countHit();
                } else {
                    this.countMiss();
                }
            }
        }
        return entry;
    }

    public boolean sendCache(byte[] req, int start, int length, SocketChannel socketChannel, boolean keepAlive) {
        try {
            FileCacheEntry entry = this.map(req, start, length);
            if (entry != null && entry.bb != nullByteBuffer) {
                this.sendCache(socketChannel, entry, keepAlive);
                return true;
            }
        }
        catch (IOException ex) {
            SelectorThread.logger().fine("File Cache: " + ex.getMessage());
            return true;
        }
        catch (Throwable t) {
            SelectorThread.logger().fine("File Cache thread race: " + t.getMessage());
        }
        return false;
    }

    public void setCacheManager(ConcurrentLinkedQueue<FileCacheEntry> cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void sendCache(SocketChannel socketChannel, FileCacheEntry entry, boolean keepAlive) throws IOException {
        ByteBuffer keepAliveBuf = keepAlive ? connectionKaBB.slice() : connectionCloseBB.slice();
        ByteBuffer[] scatterBB = new ByteBuffer[]{entry.headerBuffer.slice(), keepAliveBuf, entry.bb.slice()};
        OutputWriter.flushChannel((SocketChannel)socketChannel, (ByteBuffer[])scatterBB);
    }

    private void configHeaders(FileCacheEntry entry) {
        if (entry.headerBuffer == null) {
            entry.headerBuffer = ByteBuffer.allocate(this.getHeaderBBSize());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(OK);
        if (entry.xPoweredBy) {
            this.appendHeaderValue(sb, "X-Powered-By", "Servlet/2.5");
        }
        this.appendHeaderValue(sb, "ETag", entry.Etag);
        this.appendHeaderValue(sb, "Last-Modified", entry.lastModified);
        this.appendHeaderValue(sb, "Content-Type", entry.contentType);
        this.appendHeaderValue(sb, "Content-Length", entry.bb.capacity() + "");
        this.appendHeaderValue(sb, "Date", entry.date);
        this.appendHeaderValue(sb, "Server", SelectorThread.SERVER_NAME);
        entry.headerBuffer.put(sb.toString().getBytes());
        entry.headerBuffer.flip();
    }

    private void appendHeaderValue(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append(": ");
        sb.append(value);
        sb.append(NEWLINE);
    }

    public int getFlagEnabled() {
        return this.isEnabled ? 1 : 0;
    }

    public int getSecondsMaxAge() {
        return this.secondsMaxAge;
    }

    public long getCountEntries() {
        return this.fileCache.size();
    }

    public long getMaxEntries() {
        return this.maxCacheEntries;
    }

    public long getCountOpenEntries() {
        return this.openCacheEntries;
    }

    public long getMaxOpenEntries() {
        return this.maxOpenCacheEntries;
    }

    public long getSizeHeapCache() {
        return heapSize;
    }

    public long getMaxHeapCacheSize() {
        return this.maxHeapCacheSize;
    }

    public static long getSizeMmapCache() {
        return mappedMemorySize;
    }

    public long getMaxMmapCacheSize() {
        return this.maxMappedMemory;
    }

    protected void countHit() {
        ++this.countHits;
    }

    public long getCountHits() {
        return this.countHits;
    }

    protected void countMiss() {
        ++this.countMisses;
    }

    public long getCountMisses() {
        return this.countMisses;
    }

    protected void countInfoHit() {
        ++this.countCacheHits;
    }

    public long getCountInfoHits() {
        return this.countCacheHits;
    }

    protected void countInfoMiss() {
        ++this.countCacheMisses;
    }

    public long getCountInfoMisses() {
        return this.countCacheMisses;
    }

    protected void countContentHit() {
        ++this.countMappedHits;
    }

    public long getCountContentHits() {
        return this.countMappedHits;
    }

    protected void countContentMiss() {
        ++this.countMappedMisses;
    }

    public int getCountContentMisses() {
        return this.countMappedMisses;
    }

    public static void setIsMonitoringEnabled(boolean isMe) {
        isMonitoringEnabled = isMe;
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public ConcurrentHashMap<String, FileCacheEntry> getCache() {
        return this.fileCache;
    }

    public int getHeaderBBSize() {
        return this.headerBBSize;
    }

    public void setHeaderBBSize(int headerBBSize) {
        this.headerBBSize = headerBBSize;
    }

    public final class FileCacheEntry
    implements Runnable {
        public String requestURI;
        public String lastModified;
        public String contentType;
        public ByteBuffer bb;
        public ByteBuffer headerBuffer;
        public boolean xPoweredBy;
        public boolean isInHeap = false;
        public String date;
        public String Etag;
        public Future future;

        public void run() {
            FileCache.this.fileCache.remove(this.requestURI);
            if (this.requestURI == null) {
                return;
            }
            if (this.headerBuffer != null) {
                if (this.headerBuffer.position() != 0 || this.bb.position() != 0) {
                    this.future = FileCache.this.cacheResourcesThread.schedule(this, 10L, TimeUnit.SECONDS);
                    return;
                }
                if (!this.isInHeap) {
                    mappedMemorySize -= this.bb.limit();
                } else {
                    heapSize -= this.bb.limit();
                }
                this.bb = null;
                this.headerBuffer = null;
                FileCache.this.openCacheEntries--;
            }
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
            this.requestURI = null;
            FileCache.this.cacheManager.offer(this);
        }
    }
}

