/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.ncli;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.admin.ncli.metadata.OptionDesc;
import org.glassfish.api.admin.cli.OptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProgramOptionBuilder {
    private final Set<OptionDesc> som;
    private final OptionDesc hostDesc;
    private final OptionDesc portDesc;
    private final OptionDesc userDesc;
    private final OptionDesc passwordDesc;
    private final OptionDesc pwfileDesc;
    private final OptionDesc secureDesc;
    private final OptionDesc interactiveDesc;
    private final OptionDesc echoDesc;
    private final OptionDesc terseDesc;
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String PASSWORDFILE = "passwordfile";
    public static final String SECURE = "secure";
    public static final String INTERACTIVE = "interactive";
    public static final String ECHO = "echo";
    public static final String TERSE = "terse";
    public static final char HOST_SYMBOL = 'H';
    public static final char PORT_SYMBOL = 'p';
    public static final char USER_SYMBOL = 'u';
    public static final char PASSWORD_SYMBOL = 'w';
    public static final char PASSWORDFILE_SYMBOL = 'W';
    public static final char SECURE_SYMBOL = 's';
    public static final char INTERACTIVE_SYMBOL = 'I';
    public static final char ECHO_SYMBOL = 'e';
    public static final char TERSE_SYMBOL = 't';
    private static final ProgramOptionBuilder INSTANCE = new ProgramOptionBuilder();

    private ProgramOptionBuilder() {
        HashSet<OptionDesc> t = new HashSet<OptionDesc>();
        this.hostDesc = ProgramOptionBuilder.buildHostDesc();
        t.add(this.hostDesc);
        this.portDesc = ProgramOptionBuilder.buildPortDesc();
        t.add(this.portDesc);
        this.userDesc = ProgramOptionBuilder.buildUserDesc();
        t.add(this.userDesc);
        this.passwordDesc = ProgramOptionBuilder.buildPasswordDesc();
        t.add(this.passwordDesc);
        this.pwfileDesc = this.buildPasswordfileDesc();
        t.add(this.pwfileDesc);
        this.secureDesc = this.buildSecureDesc();
        t.add(this.secureDesc);
        this.interactiveDesc = this.buildInteractiveDesc();
        t.add(this.interactiveDesc);
        this.echoDesc = this.buildEchoDesc();
        t.add(this.echoDesc);
        this.terseDesc = this.buildTerseDesc();
        t.add(this.terseDesc);
        this.som = Collections.unmodifiableSet(t);
    }

    public static ProgramOptionBuilder getInstance() {
        return INSTANCE;
    }

    public Set<OptionDesc> getAllOptionMetadata() {
        return this.som;
    }

    public OptionDesc getHostDesc() {
        return this.hostDesc;
    }

    public OptionDesc getPortDesc() {
        return this.portDesc;
    }

    public OptionDesc getUserDesc() {
        return this.userDesc;
    }

    public OptionDesc getPasswordDesc() {
        return this.passwordDesc;
    }

    public OptionDesc getPwfileDesc() {
        return this.pwfileDesc;
    }

    public OptionDesc getSecureDesc() {
        return this.secureDesc;
    }

    public OptionDesc getInteractiveDesc() {
        return this.interactiveDesc;
    }

    public OptionDesc getEchoDesc() {
        return this.echoDesc;
    }

    public OptionDesc getTerseDesc() {
        return this.terseDesc;
    }

    private static OptionDesc buildHostDesc() {
        OptionDesc h = new OptionDesc();
        h.setName(HOST);
        h.setSymbol(Character.toString('H'));
        h.setDefaultValue("localhost");
        h.setRepeats("FALSE");
        h.setRequired("FALSE");
        h.setType(OptionType.STRING.name());
        return h;
    }

    private static OptionDesc buildPortDesc() {
        OptionDesc p = new OptionDesc();
        p.setName(PORT);
        p.setSymbol(Character.toString('p'));
        p.setDefaultValue("4848");
        p.setRepeats("FALSE");
        p.setRequired("FALSE");
        p.setType(OptionType.STRING.name());
        return p;
    }

    private static OptionDesc buildUserDesc() {
        OptionDesc u = new OptionDesc();
        u.setName(USER);
        u.setSymbol(Character.toString('u'));
        u.setDefaultValue("anonymous");
        u.setRepeats("FALSE");
        u.setRequired("FALSE");
        u.setType(OptionType.STRING.name());
        return u;
    }

    private static OptionDesc buildPasswordDesc() {
        OptionDesc pwd = new OptionDesc();
        pwd.setName(PASSWORD);
        pwd.setSymbol(Character.toString('w'));
        pwd.setRepeats("FALSE");
        pwd.setRequired("FALSE");
        pwd.setType(OptionType.PASSWORD.name());
        return pwd;
    }

    private OptionDesc buildPasswordfileDesc() {
        OptionDesc pf = new OptionDesc();
        pf.setName(PASSWORDFILE);
        pf.setSymbol(Character.toString('W'));
        pf.setRepeats("FALSE");
        pf.setRequired("FALSE");
        pf.setType(OptionType.FILE_PATH.name());
        return pf;
    }

    private OptionDesc buildSecureDesc() {
        OptionDesc s = new OptionDesc();
        s.setName(SECURE);
        s.setSymbol(Character.toString('s'));
        s.setDefaultValue("FALSE");
        s.setRepeats("FALSE");
        s.setRequired("FALSE");
        s.setType(OptionType.BOOLEAN.name());
        return s;
    }

    private OptionDesc buildInteractiveDesc() {
        OptionDesc i = new OptionDesc();
        i.setName(INTERACTIVE);
        i.setSymbol(Character.toString('I'));
        i.setDefaultValue("TRUE");
        i.setRepeats("FALSE");
        i.setRequired("FALSE");
        i.setType(OptionType.BOOLEAN.name());
        return i;
    }

    private OptionDesc buildEchoDesc() {
        OptionDesc e = new OptionDesc();
        e.setName(ECHO);
        e.setSymbol(Character.toString('e'));
        e.setDefaultValue("FALSE");
        e.setRepeats("FALSE");
        e.setRequired("FALSE");
        e.setType(OptionType.BOOLEAN.name());
        return e;
    }

    private OptionDesc buildTerseDesc() {
        OptionDesc t = new OptionDesc();
        t.setName(TERSE);
        t.setSymbol(Character.toString('t'));
        t.setDefaultValue("FALSE");
        t.setRepeats("FALSE");
        t.setRequired("FALSE");
        t.setType(OptionType.BOOLEAN.name());
        return t;
    }
}

