/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Path;
import org.hibernate.validation.engine.NodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathImpl
implements Path {
    private static final Pattern pathPattern = Pattern.compile("(\\w+)(\\[(\\w+)\\])?(\\.(.*))*");
    private static final String PROPERTY_PATH_SEPERATOR = ".";
    private final List<Path.Node> nodeList = new ArrayList<Path.Node>();

    public static PathImpl createPathFromString(String propertyPath) {
        if (propertyPath == null) {
            throw new IllegalArgumentException("null is not allowed as property path.");
        }
        if (propertyPath.length() == 0) {
            return PathImpl.createNewPath(null);
        }
        return PathImpl.parseProperty(propertyPath);
    }

    public static PathImpl createNewPath(String name) {
        PathImpl path = new PathImpl();
        NodeImpl node = new NodeImpl(name);
        path.addNode(node);
        return path;
    }

    public static PathImpl createShallowCopy(PathImpl path) {
        return path == null ? null : new PathImpl(path);
    }

    private PathImpl(PathImpl path) {
        for (Path.Node aPath : path) {
            this.nodeList.add(new NodeImpl(aPath));
        }
    }

    private PathImpl() {
    }

    private PathImpl(List<Path.Node> nodeList) {
        for (Path.Node node : nodeList) {
            this.nodeList.add(new NodeImpl(node));
        }
    }

    public boolean isRootPath() {
        return this.nodeList.size() == 1 && this.nodeList.get(0).getName() == null;
    }

    public PathImpl getPathWithoutLeafNode() {
        ArrayList<Path.Node> nodes = new ArrayList<Path.Node>(this.nodeList);
        PathImpl path = null;
        if (nodes.size() > 1) {
            nodes.remove(nodes.size() - 1);
            path = new PathImpl(nodes);
        }
        return path;
    }

    public void addNode(Path.Node node) {
        this.nodeList.add(node);
    }

    public Path.Node removeLeafNode() {
        if (this.nodeList.size() == 0) {
            throw new IllegalStateException("No nodes in path!");
        }
        if (this.nodeList.size() == 1) {
            throw new IllegalStateException("Root node cannot be removed!");
        }
        return this.nodeList.remove(this.nodeList.size() - 1);
    }

    public NodeImpl getLeafNode() {
        if (this.nodeList.size() == 0) {
            throw new IllegalStateException("No nodes in path!");
        }
        return (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
    }

    @Override
    public Iterator<Path.Node> iterator() {
        return this.nodeList.iterator();
    }

    public boolean isSubPathOf(Path path) {
        Iterator pathIter = path.iterator();
        Iterator<Path.Node> thisIter = this.iterator();
        while (pathIter.hasNext()) {
            Path.Node pathNode = (Path.Node)pathIter.next();
            if (!thisIter.hasNext()) {
                return false;
            }
            Path.Node thisNode = thisIter.next();
            if (thisNode.equals(pathNode)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Path.Node> iter = this.iterator();
        while (iter.hasNext()) {
            Path.Node node = iter.next();
            builder.append(node.toString());
            if (!iter.hasNext()) continue;
            builder.append(PROPERTY_PATH_SEPERATOR);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathImpl path = (PathImpl)o;
        if (this.nodeList != null && !((Object)this.nodeList).equals(path.nodeList)) {
            return false;
        }
        return this.nodeList != null || path.nodeList == null;
    }

    public int hashCode() {
        return this.nodeList != null ? ((Object)this.nodeList).hashCode() : 0;
    }

    private static PathImpl parseProperty(String property) {
        PathImpl path = new PathImpl();
        String tmp = property;
        do {
            NodeImpl node;
            Matcher matcher;
            if ((matcher = pathPattern.matcher(tmp)).matches()) {
                String value = matcher.group(1);
                String index = matcher.group(3);
                node = new NodeImpl(value);
                if (index != null) {
                    node.setInIterable(true);
                    try {
                        Integer i = Integer.parseInt(index);
                        node.setIndex(i);
                    }
                    catch (NumberFormatException e) {
                        node.setKey(index);
                    }
                }
            } else {
                throw new IllegalArgumentException("Unable to parse property path " + property);
            }
            path.addNode(node);
            tmp = matcher.group(5);
        } while (tmp != null);
        return path;
    }
}

