/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validation.metadata.AnnotationIgnores;
import org.hibernate.validation.metadata.BeanDescriptorImpl;
import org.hibernate.validation.metadata.BeanMetaData;
import org.hibernate.validation.metadata.ConstraintDescriptorImpl;
import org.hibernate.validation.metadata.ConstraintHelper;
import org.hibernate.validation.metadata.MetaConstraint;
import org.hibernate.validation.metadata.PropertyDescriptorImpl;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Logger log = LoggerFactory.make();
    private final Class<T> beanClass;
    private BeanDescriptorImpl<T> beanDescriptor;
    private Map<Class<?>, List<MetaConstraint<T, ? extends Annotation>>> metaConstraints = new HashMap();
    private List<Member> cascadedMembers = new ArrayList<Member>();
    private Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private List<Class<?>> defaultGroupSequence = new ArrayList();
    private final ConstraintHelper constraintHelper;
    private final Set<String> propertyNames = new HashSet<String>(30);

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper) {
        this(beanClass, constraintHelper, new AnnotationIgnores());
    }

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper, AnnotationIgnores annotationIgnores) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.createMetaData(annotationIgnores);
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public List<Member> getCascadedMembers() {
        return Collections.unmodifiableList(this.cascadedMembers);
    }

    @Override
    public Map<Class<?>, List<MetaConstraint<T, ? extends Annotation>>> geMetaConstraintsAsMap() {
        return Collections.unmodifiableMap(this.metaConstraints);
    }

    @Override
    public List<MetaConstraint<T, ? extends Annotation>> geMetaConstraintsAsList() {
        ArrayList<MetaConstraint<T, ? extends Annotation>> constraintList = new ArrayList<MetaConstraint<T, ? extends Annotation>>();
        for (List<MetaConstraint<T, ? extends Annotation>> list : this.metaConstraints.values()) {
            constraintList.addAll(list);
        }
        return Collections.unmodifiableList(constraintList);
    }

    public void addMetaConstraint(Class<?> clazz, MetaConstraint<T, ? extends Annotation> metaConstraint) {
        List<Object> constraintList;
        if (!this.metaConstraints.containsKey(clazz)) {
            constraintList = new ArrayList();
            this.metaConstraints.put(clazz, constraintList);
        } else {
            constraintList = this.metaConstraints.get(clazz);
        }
        constraintList.add(metaConstraint);
    }

    public void addCascadedMember(Member member) {
        this.cascadedMembers.add(member);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String property) {
        return this.propertyDescriptors.get(property);
    }

    @Override
    public boolean isPropertyPresent(String name) {
        return this.propertyNames.contains(name);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence() {
        return Collections.unmodifiableList(this.defaultGroupSequence);
    }

    @Override
    public boolean defaultGroupSequenceIsRedefined() {
        return this.defaultGroupSequence.size() > 1;
    }

    public void setDefaultGroupSequence(List<Class<?>> groupSequence) {
        this.defaultGroupSequence = new ArrayList();
        boolean groupSequenceContainsDefault = false;
        for (Class<?> group : groupSequence) {
            if (group.getName().equals(this.beanClass.getName())) {
                this.defaultGroupSequence.add(Default.class);
                groupSequenceContainsDefault = true;
                continue;
            }
            if (group.getName().equals(Default.class.getName())) {
                throw new GroupDefinitionException("'Default.class' cannot appear in default group sequence list.");
            }
            this.defaultGroupSequence.add(group);
        }
        if (!groupSequenceContainsDefault) {
            throw new GroupDefinitionException(this.beanClass.getName() + " must be part of the redefined default group sequence.");
        }
        if (log.isTraceEnabled()) {
            log.trace("Members of the default group sequence for bean {} are: {}", (Object)this.beanClass.getName(), this.defaultGroupSequence);
        }
    }

    @Override
    public Set<PropertyDescriptor> getConstrainedProperties() {
        return Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(this.propertyDescriptors.values()));
    }

    private void createMetaData(AnnotationIgnores annotationIgnores) {
        this.beanDescriptor = new BeanDescriptorImpl(this);
        this.initDefaultGroupSequence();
        ArrayList<Class> classes = new ArrayList<Class>();
        this.computeClassHierarchy(this.beanClass, classes);
        for (Class current : classes) {
            this.initClass(current, annotationIgnores);
        }
    }

    private void computeClassHierarchy(Class clazz, List<Class> classes) {
        if (log.isTraceEnabled()) {
            log.trace("Processing: {}", clazz);
        }
        for (Class current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                this.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private void initClass(Class clazz, AnnotationIgnores annotationIgnores) {
        this.initClassConstraints(clazz, annotationIgnores);
        this.initMethodConstraints(clazz, annotationIgnores);
        this.initFieldConstraints(clazz, annotationIgnores);
    }

    private void initDefaultGroupSequence() {
        ArrayList groupSequence = new ArrayList();
        GroupSequence groupSequenceAnnotation = this.beanClass.getAnnotation(GroupSequence.class);
        if (groupSequenceAnnotation == null) {
            groupSequence.add(this.beanClass);
        } else {
            groupSequence.addAll(Arrays.asList(groupSequenceAnnotation.value()));
        }
        this.setDefaultGroupSequence(groupSequence);
    }

    private void initFieldConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String name = ReflectionHelper.getPropertyName(field);
            if (name != null) {
                this.propertyNames.add(name);
            }
            List<ConstraintDescriptorImpl<?>> fieldMetadata = this.findConstraints(field);
            for (ConstraintDescriptorImpl<?> constraintDescription : fieldMetadata) {
                if (annotationIgnores.isIgnoreAnnotations(field)) break;
                ReflectionHelper.setAccessibility(field);
                MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(field, constraintDescription);
                this.addMetaConstraint(clazz, metaConstraint);
            }
            if (!field.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(field);
            this.cascadedMembers.add(field);
            this.addPropertyDescriptorForMember(field);
        }
    }

    private void initMethodConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            String name = ReflectionHelper.getPropertyName(method);
            if (name != null) {
                this.propertyNames.add(name);
            }
            List<ConstraintDescriptorImpl<?>> methodMetadata = this.findConstraints(method);
            for (ConstraintDescriptorImpl<?> constraintDescription : methodMetadata) {
                if (annotationIgnores.isIgnoreAnnotations(method)) break;
                ReflectionHelper.setAccessibility(method);
                MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(method, constraintDescription);
                this.addMetaConstraint(clazz, metaConstraint);
            }
            if (!method.isAnnotationPresent(Valid.class)) continue;
            ReflectionHelper.setAccessibility(method);
            this.cascadedMembers.add(method);
            this.addPropertyDescriptorForMember(method);
        }
    }

    private PropertyDescriptorImpl addPropertyDescriptorForMember(Member member) {
        String name = ReflectionHelper.getPropertyName(member);
        PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            propertyDescriptor = new PropertyDescriptorImpl(ReflectionHelper.getType(member), ((AnnotatedElement)((Object)member)).isAnnotationPresent(Valid.class), name);
            this.propertyDescriptors.put(name, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private void initClassConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        if (annotationIgnores.isIgnoreAnnotations(clazz)) {
            return;
        }
        List<ConstraintDescriptorImpl<?>> classMetadata = this.findClassLevelConstraints(clazz);
        for (ConstraintDescriptorImpl<?> constraintDescription : classMetadata) {
            MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(constraintDescription);
            this.addMetaConstraint(clazz, metaConstraint);
        }
    }

    private <A extends Annotation> MetaConstraint<T, ?> createMetaConstraint(ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<T, A>(this.beanClass, descriptor);
    }

    private <A extends Annotation> MetaConstraint<T, ?> createMetaConstraint(Member m, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<T, A>(m, this.beanClass, descriptor);
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl<?>> findConstraintAnnotations(Class<?> clazz, A annotation) {
        ArrayList constraintDescriptors = new ArrayList();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        if (this.constraintHelper.isConstraintAnnotation(annotation) || this.constraintHelper.isBuiltinConstraint(annotation.annotationType())) {
            constraints.add(annotation);
        }
        constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl constraintDescriptor = this.buildConstraintDescriptor(clazz, constraint);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> ConstraintDescriptorImpl buildConstraintDescriptor(Class<?> clazz, A annotation) {
        ConstraintDescriptorImpl<A> constraintDescriptor = clazz.isInterface() && !clazz.equals(this.beanClass) ? new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, clazz) : new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper);
        return constraintDescriptor;
    }

    private List<ConstraintDescriptorImpl<?>> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList metadata = new ArrayList();
        for (Annotation annotation : beanClass.getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(beanClass, annotation));
        }
        for (ConstraintDescriptorImpl constraintDescriptorImpl : metadata) {
            this.beanDescriptor.addConstraintDescriptor(constraintDescriptorImpl);
        }
        return metadata;
    }

    /*
     * WARNING - void declaration
     */
    private List<ConstraintDescriptorImpl<?>> findConstraints(Member member) {
        void var5_7;
        assert (member instanceof Field || member instanceof Method);
        ArrayList metadata = new ArrayList();
        Annotation[] arr$ = ((AnnotatedElement)((Object)member)).getAnnotations();
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            Annotation annotation = arr$[var5_7];
            metadata.addAll(this.findConstraintAnnotations(member.getDeclaringClass(), annotation));
            ++var5_7;
        }
        String name = ReflectionHelper.getPropertyName(member);
        for (ConstraintDescriptorImpl constraintDescriptorImpl : metadata) {
            if (member instanceof Method && name == null) {
                throw new ValidationException("Annotated methods must follow the JavaBeans naming convention. " + member.getName() + "() does not.");
            }
            PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
            if (propertyDescriptor == null) {
                propertyDescriptor = this.addPropertyDescriptorForMember(member);
            }
            propertyDescriptor.addConstraintDescriptor(constraintDescriptorImpl);
        }
        return metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanMetaDataImpl");
        sb.append("{beanClass=").append(this.beanClass);
        sb.append(", beanDescriptor=").append(this.beanDescriptor);
        sb.append(", metaConstraints=").append(this.metaConstraints);
        sb.append(", cascadedMembers=").append(this.cascadedMembers);
        sb.append(", propertyDescriptors=").append(this.propertyDescriptors);
        sb.append(", defaultGroupSequence=").append(this.defaultGroupSequence);
        sb.append(", constraintHelper=").append(this.constraintHelper);
        sb.append('}');
        return sb.toString();
    }
}

