/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.felix.shell.Command;
import org.apache.felix.shell.impl.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackagesCommandImpl
implements Command {
    private BundleContext m_context = null;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;

    public PackagesCommandImpl(BundleContext context) {
        this.m_context = context;
    }

    public String getName() {
        return "packages";
    }

    public String getUsage() {
        return "packages [<id> ...]";
    }

    public String getShortDescription() {
        return "list exported packages.";
    }

    public void execute(String s, PrintStream out, PrintStream err) {
        ServiceReference ref = this.m_context.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = PackagesCommandImpl.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
        if (ref == null) {
            out.println("PackageAdmin service is unavailable.");
            return;
        }
        PackageAdmin pa = (PackageAdmin)this.m_context.getService(ref);
        if (pa == null) {
            out.println("PackageAdmin service is unavailable.");
            return;
        }
        StringTokenizer st = new StringTokenizer(s, " ");
        st.nextToken();
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                String id = st.nextToken();
                try {
                    long l = Long.parseLong(id);
                    Bundle bundle = this.m_context.getBundle(l);
                    ExportedPackage[] exports = pa.getExportedPackages(bundle);
                    this.printExports(out, bundle, exports);
                }
                catch (NumberFormatException ex) {
                    err.println("Unable to parse id '" + id + "'.");
                }
                catch (Exception ex) {
                    err.println(ex.toString());
                }
            }
        } else {
            ExportedPackage[] exports = pa.getExportedPackages((Bundle)null);
            this.printExports(out, null, exports);
        }
    }

    private void printExports(PrintStream out, Bundle target, ExportedPackage[] exports) {
        if (exports != null && exports.length > 0) {
            for (int i = 0; i < exports.length; ++i) {
                Bundle bundle = exports[i].getExportingBundle();
                out.print(Util.getBundleName(bundle));
                out.println(": " + exports[i]);
            }
        } else {
            out.println(Util.getBundleName(target) + ": No active exported packages.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

