/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Set;

public abstract class LocalDomainCommand
extends CLICommand {
    protected File domainsDir;
    protected File domainRootDir;
    protected String domainName;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalDomainCommand.class);

    protected LocalDomainCommand(String name, ProgramOptions programOpts, Environment env) {
        super(name, programOpts, env);
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        this.initDomain();
    }

    protected void initDomain() throws CommandValidationException {
        String domaindir;
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.get(0);
        }
        if (LocalDomainCommand.ok(domaindir = this.getOption("domaindir"))) {
            this.domainsDir = new File(domaindir);
            if (!this.domainsDir.isDirectory()) {
                throw new CommandValidationException(strings.get("Domain.badDomainsDir", new Object[]{this.domainsDir}));
            }
        }
        if (this.domainsDir == null) {
            this.domainsDir = new File(this.getSystemProperty("com.sun.aas.domainsRoot"));
        }
        if (!this.domainsDir.isDirectory()) {
            throw new CommandValidationException(strings.get("Domain.badDomainsDir", new Object[]{this.domainsDir}));
        }
        if (this.domainName != null) {
            this.domainRootDir = new File(this.domainsDir, this.domainName);
        } else {
            this.domainRootDir = this.getTheOneAndOnlyDomain(this.domainsDir);
            this.domainName = this.domainRootDir.getName();
        }
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandValidationException(strings.get("Domain.badDomainDir", new Object[]{this.domainRootDir}));
        }
        this.domainRootDir = SmartFile.sanitize((File)this.domainRootDir);
        this.domainsDir = SmartFile.sanitize((File)this.domainsDir);
        this.initializeLocalPassword();
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandValidationException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandValidationException(strings.get("Domain.noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            throw new CommandValidationException(strings.get("Domain.tooManyDomainDirs", new Object[]{parent}));
        }
        return files[0];
    }

    protected File getDomainXml() throws CommandValidationException {
        File domainXml = new File(new File(this.domainRootDir, "config"), "domain.xml");
        if (!domainXml.canRead()) {
            throw new CommandValidationException(strings.get("Domain.noDomainXml", new Object[]{domainXml}));
        }
        return domainXml;
    }

    protected File getMasterPasswordFile() {
        File mp = new File(this.domainRootDir, "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeLocalPassword() {
        File localPassword = new File(new File(this.domainRootDir, "config"), "local-password");
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(localPassword));
            String pwd = r.readLine();
            if (LocalDomainCommand.ok(pwd)) {
                logger.printDebugMessage("Using local password");
                this.programOpts.setPassword(pwd);
                if (this.programOpts.getUser() == null) {
                    this.programOpts.setUser("anonymous");
                }
            }
        }
        catch (IOException ex) {
            logger.printDebugMessage("IOException reading local password: " + ex);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getJKS() {
        File mp = new File(new File(this.domainRootDir, "config"), "keystore.jks");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyMasterPassword(String mpv) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getJKS());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, mpv.toCharArray());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.printDebugMessage(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    protected String checkMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            logger.printDebugMessage("master password file reading error: " + e.getMessage());
            return null;
        }
    }

    protected int getAdminPort() throws CommandValidationException, CommandException {
        try {
            MiniXmlParser parser = new MiniXmlParser(this.getDomainXml());
            Set portsSet = parser.getAdminPorts();
            Integer[] ports = portsSet.toArray(new Integer[portsSet.size()]);
            return ports[0];
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException("admin port not found", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRunning(int port) {
        Socket server = null;
        try {
            String host = null;
            server = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.printDebugMessage("\nisRunning got exception: " + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

