/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.LinkedHashSet;

public class StopDomainCommand
extends LocalDomainCommand {
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);

    public StopDomainCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException, CommandValidationException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        StopDomainCommand.addOption(opts, "domaindir", '\u0000', "STRING", false, null);
        StopDomainCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
        this.processProgramOptions();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        int adminPort = this.getAdminPort();
        this.programOpts.setPort(adminPort);
        if (!DASUtils.pingDASQuietly(this.programOpts, this.env)) {
            logger.printWarning(strings.get("StopDomain.dasNotRunning"));
            return 0;
        }
        RemoteCommand cmd = new RemoteCommand("stop-domain", this.programOpts, this.env);
        cmd.executeAndReturnOutput("stop-domain");
        this.waitForDeath(adminPort);
        return 0;
    }

    private void waitForDeath(int adminPort) throws CommandException {
        long startWait = System.currentTimeMillis();
        System.err.print(strings.get("StopDomain.WaitDASDeath") + " ");
        boolean alive = true;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning(adminPort)) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                System.err.print(".");
            }
            catch (InterruptedException ex) {}
        }
        System.err.println();
        if (alive) {
            throw new CommandException(strings.get("StopDomain.DASNotDead", new Object[]{60L}));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }
}

