/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.glassfish.api.admin.FileMonitoring;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class FileMonitoringImpl
implements FileMonitoring,
PostConstruct {
    @Inject
    ExecutorService executor;
    @Inject
    ScheduledExecutorService scheduledExecutor;
    final Map<File, List<FileMonitoring.FileChangeListener>> listeners = new HashMap<File, List<FileMonitoring.FileChangeListener>>();
    final Map<File, Long> monitored = new HashMap<File, Long>();

    public void postConstruct() {
        this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                if (FileMonitoringImpl.this.monitored.isEmpty()) {
                    return;
                }
                HashSet<File> monitoredFiles = new HashSet<File>();
                monitoredFiles.addAll(FileMonitoringImpl.this.listeners.keySet());
                for (File file : monitoredFiles) {
                    if (!file.exists()) {
                        FileMonitoringImpl.this.removed(file);
                        FileMonitoringImpl.this.listeners.remove(file);
                        FileMonitoringImpl.this.monitored.remove(file);
                        continue;
                    }
                    if (file.lastModified() == FileMonitoringImpl.this.monitored.get(file).longValue()) continue;
                    FileMonitoringImpl.this.monitored.put(file, file.lastModified());
                    FileMonitoringImpl.this.changed(file);
                }
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public synchronized void monitors(File file, FileMonitoring.FileChangeListener listener) {
        if (this.monitored.containsKey(file)) {
            this.listeners.get(file).add(listener);
        } else {
            ArrayList<FileMonitoring.FileChangeListener> list = new ArrayList<FileMonitoring.FileChangeListener>();
            list.add(listener);
            this.listeners.put(file, list);
            this.monitored.put(file, file.lastModified());
        }
    }

    private void removed(final File file) {
        for (final FileMonitoring.FileChangeListener listener : this.listeners.get(file)) {
            this.executor.submit(new Runnable(){

                public void run() {
                    listener.deleted(file);
                }
            });
        }
    }

    private void changed(final File file) {
        for (final FileMonitoring.FileChangeListener listener : this.listeners.get(file)) {
            this.executor.submit(new Runnable(){

                public void run() {
                    listener.changed(file);
                }
            });
        }
    }
}

