/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;

public class ProbeProviderRegistry {
    private static ProbeProviderRegistry _me = new ProbeProviderRegistry();
    private ConcurrentMap<String, FlashlightProbeProvider> providerMap = new ConcurrentHashMap<String, FlashlightProbeProvider>();

    private ProbeProviderRegistry() {
    }

    public static ProbeProviderRegistry getInstance() {
        return _me;
    }

    public FlashlightProbeProvider getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName) {
        String qname = moduleProviderName + ":" + moduleName + ":" + (probeProviderName == null ? "" : probeProviderName);
        return (FlashlightProbeProvider)this.providerMap.get(qname);
    }

    public FlashlightProbeProvider registerProbeProvider(FlashlightProbeProvider provider, Class clz) {
        String qname = provider.getModuleProviderName() + ":" + provider.getModuleName() + ":" + (provider.getProbeProviderName() == null ? clz.getName() : provider.getProbeProviderName());
        if (this.providerMap.putIfAbsent(qname, provider) != null) {
            throw new IllegalStateException("Provider already mapped " + qname);
        }
        return provider;
    }
}

