/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleInfo {
    private static final Logger logger = LogDomains.getLogger(ApplicationInfo.class, (String)"javax.enterprise.system.core");
    protected Set<EngineRef> engines = new LinkedHashSet<EngineRef>();
    protected final String name;
    protected final Events events;
    private Properties moduleProps;
    private boolean started = false;
    private ClassLoader moduleClassLoader;

    public ModuleInfo(Events events, String name, Collection<EngineRef> refs, Properties moduleProps) {
        this.name = name;
        this.events = events;
        for (EngineRef ref : refs) {
            this.engines.add(ref);
        }
        this.moduleProps = moduleProps;
    }

    public Set<EngineRef> getEngineRefs() {
        LinkedHashSet<EngineRef> copy = new LinkedHashSet<EngineRef>();
        copy.addAll(this._getEngineRefs());
        return copy;
    }

    protected Set<EngineRef> _getEngineRefs() {
        return this.engines;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef engine : this._getEngineRefs()) {
            sniffers.add(engine.getContainerInfo().getSniffer());
        }
        return sniffers;
    }

    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        ActionReport report = context.getActionReport();
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        this.moduleClassLoader = context.getClassLoader();
        if (!context.getTransformers().isEmpty()) {
            try {
                InstrumentableClassLoader icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(context.getFinalClassLoader());
                for (ClassFileTransformer transformer : context.getTransformers()) {
                    icl.addTransformer(transformer);
                }
            }
            catch (Exception e) {
                report.failure(logger, "Class loader used for loading application cannot handle bytecode enhancer", (Throwable)e);
                throw e;
            }
        }
        LinkedHashSet<EngineRef> filteredEngines = new LinkedHashSet<EngineRef>();
        for (EngineRef engine : this._getEngineRefs()) {
            EngineInfo engineInfo = engine.getContainerInfo();
            Deployer deployer = engineInfo.getDeployer();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                ApplicationContainer appCtr = deployer.load(engineInfo.getContainer(), (DeploymentContext)context);
                if (appCtr == null) {
                    String msg = "Cannot load application in " + engineInfo.getContainer().getName() + " container";
                    logger.fine(msg);
                    continue;
                }
                engine.load(context, tracker);
                engine.setApplicationContainer(appCtr);
                filteredEngines.add(engine);
            }
            catch (Exception e) {
                report.failure(logger, "Exception while invoking " + deployer.getClass() + " load method", (Throwable)e);
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        this.engines = filteredEngines;
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_LOADED, (Object)this), false);
        }
    }

    public <T extends Container> EngineRef getEngineRefForContainer(Class<T> type) {
        for (EngineRef engine : this._getEngineRefs()) {
            Container container = null;
            try {
                container = (Container)type.cast(engine.getContainerInfo().getContainer());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (container == null) continue;
            return engine;
        }
        return null;
    }

    public synchronized void start(DeploymentContext context, ProgressTracker tracker) throws Exception {
        ActionReport report = context.getActionReport();
        if (this.started) {
            return;
        }
        for (EngineRef engine : this._getEngineRefs()) {
            if (context.getLogger().isLoggable(Level.FINE)) {
                context.getLogger().fine("starting " + engine.getContainerInfo().getSniffer().getModuleType());
            }
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                if (engine.start((ApplicationContext)context, tracker)) continue;
                report.failure(logger, "Module not started " + engine.getApplicationContainer().toString());
                throw new Exception("Module not started " + engine.getApplicationContainer().toString());
            }
            catch (Exception e) {
                report.failure(logger, "Exception while invoking " + engine.getApplicationContainer().getClass() + " start method", (Throwable)e);
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        this.started = true;
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_STARTED, (Object)this), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(ApplicationContext context, Logger logger) {
        if (!this.started) {
            return;
        }
        for (EngineRef module : this._getEngineRefs()) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
                module.stop(context);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot stop module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        this.started = false;
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_STOPPED, (Object)this), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(ExtendedDeploymentContext context) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        for (EngineRef engine : this._getEngineRefs()) {
            if (engine.getApplicationContainer() == null || engine.getApplicationContainer().getClassLoader() == null) continue;
            classLoaders.add(engine.getApplicationContainer().getClassLoader());
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
                engine.unload(context);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to unload from container type : " + engine.getContainerInfo().getSniffer().getModuleType(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        for (ClassLoader cloader : classLoaders) {
            try {
                ((PreDestroy)PreDestroy.class.cast(cloader)).preDestroy();
            }
            catch (Exception e) {}
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_UNLOADED, (Object)this), false);
        }
    }

    public void clean(ExtendedDeploymentContext context) throws Exception {
        for (EngineRef ref : this._getEngineRefs()) {
            ref.clean(context);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_CLEANED, (Object)context), false);
        }
    }

    public boolean suspend(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef engine : this._getEngineRefs()) {
            try {
                engine.getApplicationContainer().suspend();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error suspending module " + engine.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public boolean resume(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef module : this._getEngineRefs()) {
            try {
                module.getApplicationContainer().resume();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error resuming module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public void save(Module module) throws TransactionFailure, PropertyVetoException {
        module.setName(this.name);
        for (String string : this.moduleProps.keySet()) {
            if (string.equals("location") || string.equals("object-type") || string.equals("context-root") || string.equals("directory-deployed") || string.equals("isComposite") || string.startsWith("appConfig")) continue;
            Property prop = (Property)module.createChild(Property.class);
            module.getProperty().add(prop);
            prop.setName(string);
            prop.setValue(this.moduleProps.getProperty(string));
        }
        for (EngineRef engineRef : this._getEngineRefs()) {
            Engine engine = (Engine)module.createChild(Engine.class);
            module.getEngines().add(engine);
            engineRef.save(engine);
        }
    }
}

