/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validation.engine.ValidatorContextImpl;
import org.hibernate.validation.metadata.AnnotationIgnores;
import org.hibernate.validation.metadata.BeanMetaDataCache;
import org.hibernate.validation.metadata.BeanMetaDataImpl;
import org.hibernate.validation.metadata.ConstraintHelper;
import org.hibernate.validation.metadata.MetaConstraint;
import org.hibernate.validation.xml.XmlMappingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFactoryImpl
implements ValidatorFactory {
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.constraintHelper = new ConstraintHelper();
        this.beanMetaDataCache = new BeanMetaDataCache();
        this.initBeanMetaData(configurationState.getMappingStreams());
    }

    @Override
    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        throw new ValidationException("Type " + type + " not supported");
    }

    @Override
    public ValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.constraintHelper, this.beanMetaDataCache);
    }

    private <T> void initBeanMetaData(Set<InputStream> mappingStreams) {
        XmlMappingParser mappingParser = new XmlMappingParser(this.constraintHelper);
        mappingParser.parse(mappingStreams);
        AnnotationIgnores annotationIgnores = mappingParser.getAnnotationIgnores();
        Iterator<Class<?>> i$ = mappingParser.getProcessedClasses().iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, annotationIgnores);
            for (MetaConstraint<?, Annotation> constraint : mappingParser.getConstraintsForClass(beanClass)) {
                metaData.addMetaConstraint(beanClass, constraint);
            }
            for (Member m : mappingParser.getCascadedMembersForClass(beanClass)) {
                metaData.addCascadedMember(m);
            }
            if (!mappingParser.getDefaultSequenceForClass(beanClass).isEmpty()) {
                metaData.setDefaultGroupSequence(mappingParser.getDefaultSequenceForClass(beanClass));
            }
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }
}

