/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Controller;
import com.sun.grizzly.config.GrizzlyServiceListener;
import com.sun.grizzly.config.Utils;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyConfig {
    private static final Logger logger = LoggerUtils.getLogger();
    private final NetworkConfig config;
    private Habitat habitat;
    private final List<GrizzlyServiceListener> listeners = new ArrayList<GrizzlyServiceListener>();

    public GrizzlyConfig(String file) {
        this.habitat = Utils.getHabitat(file);
        this.config = (NetworkConfig)this.habitat.getComponent(NetworkConfig.class);
    }

    public NetworkConfig getConfig() {
        return this.config;
    }

    public List<GrizzlyServiceListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupNetwork() throws IOException, InstantiationException {
        GrizzlyConfig.validateConfig(this.config);
        List<GrizzlyServiceListener> list = this.listeners;
        synchronized (list) {
            for (NetworkListener listener : this.config.getNetworkListeners().getNetworkListener()) {
                GrizzlyServiceListener grizzlyListener = new GrizzlyServiceListener(new Controller());
                grizzlyListener.configure(listener, this.habitat);
                this.listeners.add(grizzlyListener);
                WorkerThreadImpl thread = new WorkerThreadImpl(new ListenerRunnable(grizzlyListener));
                thread.setDaemon(true);
                thread.start();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNetwork() {
        List<GrizzlyServiceListener> list = this.listeners;
        synchronized (list) {
            for (GrizzlyServiceListener listener : this.listeners) {
                try {
                    listener.stop();
                }
                catch (Exception e) {}
            }
            this.listeners.clear();
        }
    }

    private static void validateConfig(NetworkConfig config) {
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            listener.findHttpProtocol();
        }
    }

    public void shutdown() {
        for (GrizzlyServiceListener listener : this.listeners) {
            listener.stop();
        }
    }

    private static class ListenerRunnable
    implements Runnable {
        private final GrizzlyServiceListener grizzlyListener;

        public ListenerRunnable(GrizzlyServiceListener grizzlyListener) {
            this.grizzlyListener = grizzlyListener;
        }

        public void run() {
            try {
                this.grizzlyListener.start();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

