/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded;

import java.io.File;
import org.jvnet.hk2.component.PreDestroy;

public class EmbeddedFileSystem
implements PreDestroy {
    public final boolean autoDelete;
    public final boolean cookedMode;
    public final File installRoot;
    public final File instanceRoot;
    public final File configFile;

    private EmbeddedFileSystem(Builder builder) {
        this.autoDelete = builder.autoDelete;
        this.installRoot = builder.installRoot;
        this.instanceRoot = builder.instanceRoot;
        this.configFile = builder.configFile;
        this.cookedMode = builder.cookedMode;
    }

    public void preDestroy() {
        System.out.println("delete " + this.instanceRoot + " = " + this.autoDelete);
        if (this.autoDelete) {
            System.out.println("Deleting recursively" + this.instanceRoot);
            this.deleteAll(this.instanceRoot);
        }
    }

    private void deleteAll(File f) {
        for (File child : f.listFiles()) {
            if (child.isDirectory()) {
                this.deleteAll(child);
                continue;
            }
            child.delete();
        }
        f.delete();
    }

    public static class Builder {
        boolean autoDelete = false;
        boolean cookedMode = false;
        File configFile = null;
        File installRoot = null;
        File instanceRoot = null;

        public Builder setAutoDelete(boolean b) {
            this.autoDelete = b;
            return this;
        }

        public Builder setConfigurationFile(File f) {
            this.configFile = f;
            return this;
        }

        public Builder setInstallRoot(File f) {
            return this.setInstallRoot(f, false);
        }

        public Builder setInstallRoot(File f, boolean cookedMode) {
            this.installRoot = f;
            this.cookedMode = cookedMode;
            return this;
        }

        public Builder setInstanceRoot(File f) {
            this.instanceRoot = f;
            if (this.configFile == null) {
                File tmp = new File(this.instanceRoot, "config");
                this.configFile = new File(tmp, "domain.xml");
                if (!this.configFile.exists()) {
                    this.configFile = null;
                }
            }
            return this;
        }

        public EmbeddedFileSystem build() {
            return new EmbeddedFileSystem(this);
        }
    }
}

