/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.metadata;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validation.engine.ConstraintTree;
import org.hibernate.validation.engine.GlobalExecutionContext;
import org.hibernate.validation.engine.LocalExecutionContext;
import org.hibernate.validation.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaConstraint<T, A extends Annotation> {
    private final Member member;
    private final String propertyName;
    private final ElementType elementType;
    private final Class<T> beanClass;
    private final ConstraintTree<A> constraintTree;

    public MetaConstraint(Class<T> beanClass, ConstraintDescriptor<A> constraintDescriptor) {
        this.elementType = ElementType.TYPE;
        this.member = null;
        this.propertyName = null;
        this.beanClass = beanClass;
        this.constraintTree = new ConstraintTree<A>(constraintDescriptor);
    }

    public MetaConstraint(Member member, Class<T> beanClass, ConstraintDescriptor<A> constraintDescriptor) {
        if (member instanceof Method) {
            this.elementType = ElementType.METHOD;
        } else if (member instanceof Field) {
            this.elementType = ElementType.FIELD;
        } else {
            throw new IllegalArgumentException("Non allowed member type: " + member);
        }
        this.member = member;
        this.propertyName = ReflectionHelper.getPropertyName(member);
        this.beanClass = beanClass;
        this.constraintTree = new ConstraintTree<A>(constraintDescriptor);
    }

    public Set<Class<?>> getGroupList() {
        return this.constraintTree.getDescriptor().getGroups();
    }

    public ConstraintDescriptor getDescriptor() {
        return this.constraintTree.getDescriptor();
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ConstraintTree getConstraintTree() {
        return this.constraintTree;
    }

    public <T, U, V> boolean validateConstraint(GlobalExecutionContext<T> executionContext, LocalExecutionContext<U, V> localExecutionContext) {
        ArrayList constraintViolations = new ArrayList();
        localExecutionContext.setElementType(this.elementType);
        this.constraintTree.validateConstraints(this.typeOfAnnoatedElement(), executionContext, localExecutionContext, constraintViolations);
        if (constraintViolations.size() > 0) {
            executionContext.addConstraintFailures(constraintViolations);
            return false;
        }
        return true;
    }

    public Object getValue(Object o) {
        switch (this.elementType) {
            case TYPE: {
                return o;
            }
        }
        return ReflectionHelper.getValue(this.member, o);
    }

    private Type typeOfAnnoatedElement() {
        Type t;
        switch (this.elementType) {
            case TYPE: {
                t = this.beanClass;
                break;
            }
            default: {
                t = ReflectionHelper.typeOf(this.member);
                if (!(t instanceof Class) || !((Class)t).isPrimitive()) break;
                t = ReflectionHelper.boxedTyp(t);
            }
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetaConstraint");
        sb.append("{propertyName='").append(this.propertyName).append('\'');
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", beanClass=").append(this.beanClass);
        sb.append('}');
        return sb.toString();
    }
}

