/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.util.Iterator;
import java.util.TreeSet;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-contracts", metadata="mode=debug")
@Scoped(value=PerLookup.class)
public class ListContracts
implements AdminCommand {
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Habitat habitat;
    @Param(primary=true, optional=true)
    String contract = null;
    @Param(optional=true)
    String started = "false";

    public void execute(AdminCommandContext context) {
        StringBuilder sb = new StringBuilder();
        if (this.contract == null) {
            this.dumpContracts(sb);
        } else {
            this.dumpInhabitantsImplementingContractPattern(this.contract, sb);
        }
        String msg = sb.toString();
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (report instanceof PropsFileActionReporter) {
            msg = ManifestUtils.encode((String)msg);
        }
        report.setMessage(msg);
    }

    private void dumpContracts(StringBuilder sb) {
        sb.append("\n*********** Sorted List of all Registered Contracts in the Habitat **************\n");
        Iterator it = this.habitat.getAllContracts();
        if (it == null) {
            return;
        }
        TreeSet contracts = new TreeSet();
        while (it != null && it.hasNext()) {
            contracts.add(it.next());
        }
        it = contracts.iterator();
        int i = 1;
        while (it.hasNext()) {
            sb.append("Contract-" + i + ": " + (String)it.next() + "\n");
            ++i;
        }
    }

    private void dumpInhabitantsImplementingContractPattern(String pattern, StringBuilder sb) {
        sb.append("\n*********** List of all services for contract named like " + this.contract + " **************\n");
        Iterator it = this.habitat.getAllContracts();
        while (it.hasNext()) {
            String cn = (String)it.next();
            if (cn.toLowerCase().indexOf(pattern.toLowerCase()) < 0) continue;
            sb.append("\n-----------------------------\n");
            for (Inhabitant i : this.habitat.getInhabitantsByContract(cn)) {
                sb.append("Inhabitant-Metadata: " + i.metadata().toCommaSeparatedString());
                sb.append("\n");
                boolean isStarted = Boolean.parseBoolean(this.started);
                if (!isStarted) continue;
                sb.append(i.isInstantiated() ? " started" : " not started");
            }
        }
    }
}

