/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticResourcesAdapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;

public abstract class DynamicContentAdapter
extends StaticResourcesAdapter {
    private static final int MAX_POST_SIZE = 49152;
    protected static final String RFC_2616_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    protected String contextRoot = null;

    public DynamicContentAdapter(String publicDirectory) {
        super(publicDirectory);
    }

    protected abstract int getTokenID();

    protected abstract void serviceDynamicContent(Request var1, Response var2) throws IOException;

    public void afterService(Request req, Response res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    private boolean modifiedSince(Request req, File file) {
        try {
            String since = req.getMimeHeaders().getHeader("If-Modified-Since");
            if (since == null) {
                return false;
            }
            Date date = new SimpleDateFormat(RFC_2616_FORMAT, Locale.US).parse(since);
            return date.getTime() > file.lastModified();
        }
        catch (ParseException e) {
            return false;
        }
    }

    public void service(Request req, Response res) throws Exception {
        MessageBytes mb = req.requestURI();
        ByteChunk requestURI = mb.getByteChunk();
        try {
            File file;
            String uri = requestURI.toString();
            if (this.contextRoot != null && requestURI.startsWith(this.contextRoot)) {
                uri = uri.substring(this.contextRoot.length());
            }
            if ((file = new File(this.getRootFolder(), uri)).isDirectory()) {
                uri = uri + "index.html";
                file = new File(file, uri);
            }
            if (file.canRead()) {
                super.service(uri, req, res);
                return;
            }
            this.serviceDynamicContent(req, res);
        }
        catch (Exception e) {
            if (SelectorThread.logger().isLoggable(Level.SEVERE)) {
                SelectorThread.logger().log(Level.SEVERE, e.getMessage());
            }
            throw e;
        }
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public class RequestTupple
    implements ByteChunk.ByteInputChannel {
        public ByteChunk readChunk = new ByteChunk();
        public Request req;
        GrizzlyInputStream inputStream;

        public RequestTupple() {
            this.readChunk.setByteInputChannel((ByteChunk.ByteInputChannel)this);
            this.readChunk.setBytes(new byte[49152], 0, 49152);
            this.inputStream = new GrizzlyInputStream();
            this.inputStream.rt = this;
        }

        public int realReadBytes(byte[] b, int off, int len) throws IOException {
            this.req.doRead(this.readChunk);
            return this.readChunk.substract(b, off, len);
        }

        public void recycle() {
            this.req = null;
            this.readChunk.recycle();
        }
    }

    private class GrizzlyInputStream
    extends InputStream {
        public RequestTupple rt;

        private GrizzlyInputStream() {
        }

        public int read() throws IOException {
            return this.rt.readChunk.substract();
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.rt.readChunk.substract(b, off, len);
        }
    }
}

