/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.cli.resources.ResourceFactory;
import org.glassfish.admin.cli.resources.ResourcesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="add-resources")
@Scoped(value=PerLookup.class)
@I18n(value="add.resources")
public class AddResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AddResources.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="xml_file_name", primary=true)
    String xmlFileName;
    @Inject
    Resources resources;
    @Inject
    Domain domain;
    @Inject
    ResourceFactory resourceFactory;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        File file = new File(this.xmlFileName);
        if (!file.exists()) {
            report.setMessage(localStrings.getLocalString("FileNotFound", "The system cannot find the path specified: {0}", new Object[]{this.xmlFileName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ArrayList results = ResourcesManager.createResources(this.resources, this.xmlFileName, targetServer, this.resourceFactory);
            Iterator resultsIter = results.iterator();
            report.getTopMessagePart().setChildrenType("Command");
            boolean isSuccess = false;
            while (resultsIter.hasNext()) {
                ResourceStatus rs = (ResourceStatus)resultsIter.next();
                String msgToAdd = rs.getMessage();
                if (msgToAdd != null && !msgToAdd.equals("")) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(msgToAdd);
                }
                if (rs.getStatus() != 0 && !rs.isAlreadyExists()) continue;
                isSuccess = true;
            }
            report.setActionExitCode(isSuccess ? ActionReport.ExitCode.SUCCESS : ActionReport.ExitCode.FAILURE);
            if (!isSuccess) {
                report.setMessage(localStrings.getLocalString("add.resources.failed", "add-resources <{0}> failed", new Object[]{this.xmlFileName}));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AddResources.class.getName()).log(Level.SEVERE, "Something went wrong in add-resources", ex);
            report.setMessage(localStrings.getLocalString("add.resources.failed", "add-resources <{0}> failed", new Object[]{this.xmlFileName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
        }
    }
}

