/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.api.monitoring.MonitoringItem;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface MonitoringService
extends ConfigBeanProxy,
Injectable,
PropertyBag {
    @Element
    public ModuleMonitoringLevels getModuleMonitoringLevels();

    public void setModuleMonitoringLevels(ModuleMonitoringLevels var1) throws PropertyVetoException;

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Attribute(defaultValue="true")
    public String getMbeanEnabled();

    public void setMbeanEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true")
    public String getMonitoringEnabled();

    public void setMonitoringEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false")
    public String getDtraceEnabled();

    public void setDtraceEnabled(String var1) throws PropertyVetoException;

    @Element
    public List<ContainerMonitoring> getContainerMonitoring();

    @Element(value="*")
    public List<MonitoringItem> getMonitoringItems();

    @DuckTyped
    public ContainerMonitoring getContainerMonitoring(String var1);

    @DuckTyped
    public String getMonitoringLevel(String var1);

    public static class Duck {
        private static List<String> getMethods = null;

        public static ContainerMonitoring getContainerMonitoring(MonitoringService ms, String name) {
            for (ContainerMonitoring cm : ms.getContainerMonitoring()) {
                if (!cm.getName().equals(name)) continue;
                return cm;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getMonitoringLevel(MonitoringService ms, String name) {
            String level = null;
            if (getMethods == null) {
                List<String> list = getMethods = new ArrayList<String>();
                synchronized (list) {
                    for (Method method : ModuleMonitoringLevels.class.getDeclaredMethods()) {
                        String str = method.getName();
                        if (!str.startsWith("get")) continue;
                        getMethods.add(str);
                    }
                }
            }
            String rName = name.replaceAll("-", "");
            for (String methodName : getMethods) {
                if (!rName.equalsIgnoreCase(methodName.substring(3))) continue;
                Class<?>[] params = null;
                try {
                    Method mthd = ModuleMonitoringLevels.class.getMethod(methodName, params);
                    level = (String)mthd.invoke((Object)ms.getModuleMonitoringLevels(), null);
                }
                catch (NoSuchMethodException nsme) {
                    Logger.getAnonymousLogger().log(Level.WARNING, nsme.getMessage(), nsme);
                }
                catch (IllegalAccessException ile) {
                    Logger.getAnonymousLogger().log(Level.WARNING, ile.getMessage(), ile);
                }
                catch (InvocationTargetException ite) {
                    Logger.getAnonymousLogger().log(Level.WARNING, ite.getMessage(), ite);
                }
                break;
            }
            if (level != null) {
                return level;
            }
            for (ContainerMonitoring cm : ms.getContainerMonitoring()) {
                if (!cm.getName().equals(name)) continue;
                return cm.getLevel();
            }
            return null;
        }
    }
}

