/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.Map;
import org.apache.felix.framework.util.manifestparser.ManifestParser;

public class R4Library {
    private String m_libraryFile;
    private String[] m_osnames;
    private String[] m_processors;
    private String[] m_osversions;
    private String[] m_languages;
    private String m_selectionFilter;

    public R4Library(String libraryFile, String[] osnames, String[] processors, String[] osversions, String[] languages, String selectionFilter) throws Exception {
        this.m_libraryFile = libraryFile;
        this.m_osnames = osnames;
        this.m_processors = processors;
        this.m_osversions = osversions;
        this.m_languages = languages;
        this.m_selectionFilter = selectionFilter;
    }

    public String getEntryName() {
        return this.m_libraryFile;
    }

    public String[] getOSNames() {
        return this.m_osnames;
    }

    public String[] getProcessors() {
        return this.m_processors;
    }

    public String[] getOSVersions() {
        return this.m_osversions;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }

    public String getSelectionFilter() {
        return this.m_selectionFilter;
    }

    public boolean match(Map configMap, String name) {
        String libname = System.mapLibraryName(name);
        String[] exts = ManifestParser.parseDelimitedString((String)configMap.get("org.osgi.framework.library.extensions"), ",");
        int extIdx = 0;
        do {
            if (this.m_libraryFile.equals(libname) || this.m_libraryFile.endsWith("/" + libname)) {
                return true;
            }
            if (libname.endsWith(".jnilib") && this.m_libraryFile.endsWith(".dylib") ? this.m_libraryFile.equals(libname = libname.substring(0, libname.length() - 6) + "dylib") || this.m_libraryFile.endsWith("/" + libname) : this.m_libraryFile.equals(name) || this.m_libraryFile.endsWith("/" + name)) {
                return true;
            }
            int idx = libname.lastIndexOf(".");
            String string = libname = idx < 0 ? libname + "." + exts[extIdx++] : libname.substring(0, idx) + "." + exts[extIdx++];
        } while (exts != null && extIdx < exts.length);
        return false;
    }

    public String toString() {
        if (this.m_libraryFile != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_libraryFile);
            for (i = 0; this.m_osnames != null && i < this.m_osnames.length; ++i) {
                sb.append(';');
                sb.append("osname");
                sb.append('=');
                sb.append(this.m_osnames[i]);
            }
            for (i = 0; this.m_processors != null && i < this.m_processors.length; ++i) {
                sb.append(';');
                sb.append("processor");
                sb.append('=');
                sb.append(this.m_processors[i]);
            }
            for (i = 0; this.m_osversions != null && i < this.m_osversions.length; ++i) {
                sb.append(';');
                sb.append("osversion");
                sb.append('=');
                sb.append(this.m_osversions[i]);
            }
            for (i = 0; this.m_languages != null && i < this.m_languages.length; ++i) {
                sb.append(';');
                sb.append("language");
                sb.append('=');
                sb.append(this.m_languages[i]);
            }
            if (this.m_selectionFilter != null) {
                sb.append(';');
                sb.append("selection-filter");
                sb.append('=');
                sb.append('\'');
                sb.append(this.m_selectionFilter);
            }
            return sb.toString();
        }
        return "*";
    }
}

