/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validation.engine.NodeImpl;
import org.hibernate.validation.engine.PathImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private final List<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(3);
    private final Path propertyPath;
    private final ConstraintDescriptor<?> constraintDescriptor;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(Path propertyPath, ConstraintDescriptor<?> constraintDescriptor) {
        this.propertyPath = propertyPath;
        this.constraintDescriptor = constraintDescriptor;
    }

    @Override
    public void disableDefaultError() {
        this.defaultDisabled = true;
    }

    @Override
    public String getDefaultErrorMessageTemplate() {
        return (String)this.constraintDescriptor.getAttributes().get("message");
    }

    @Override
    public ConstraintValidatorContext.ErrorBuilder buildErrorWithMessageTemplate(String messageTemplate) {
        return new ErrorBuilderImpl(messageTemplate, this.propertyPath);
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public boolean isDefaultErrorDisabled() {
        return this.defaultDisabled;
    }

    public List<ErrorMessage> getErrorMessages() {
        ArrayList<ErrorMessage> returnedErrorMessages = new ArrayList<ErrorMessage>(this.errorMessages);
        if (!this.defaultDisabled) {
            returnedErrorMessages.add(new ErrorMessage(this.getDefaultErrorMessageTemplate(), this.propertyPath));
        }
        return returnedErrorMessages;
    }

    class InIterablePropertiesBuilderImpl
    implements ConstraintValidatorContext.ErrorBuilder.NodeContextBuilder {
        String messageTemplate;
        PathImpl propertyPath;

        InIterablePropertiesBuilderImpl(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
            this.propertyPath.getLeafNode().setInIterable(true);
        }

        public ConstraintValidatorContext.ErrorBuilder.NodeBuilderDefinedContext atKey(Object key) {
            this.propertyPath.getLeafNode().setKey(key);
            return new NodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext.ErrorBuilder.NodeBuilderDefinedContext atIndex(Integer index) {
            this.propertyPath.getLeafNode().setIndex(index);
            return new NodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext.ErrorBuilder.NodeBuilderCustomizableContext addSubNode(String name) {
            NodeImpl node = new NodeImpl(name);
            this.propertyPath.addNode(node);
            return new InIterableNodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext addError() {
            ConstraintValidatorContextImpl.this.errorMessages.add(new ErrorMessage(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    class InIterableNodeBuilderImpl
    implements ConstraintValidatorContext.ErrorBuilder.NodeBuilderCustomizableContext {
        String messageTemplate;
        PathImpl propertyPath;

        InIterableNodeBuilderImpl(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext.ErrorBuilder.NodeContextBuilder inIterable() {
            return new InIterablePropertiesBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext.ErrorBuilder.NodeBuilderCustomizableContext addSubNode(String name) {
            NodeImpl node = new NodeImpl(name);
            this.propertyPath.addNode(node);
            return this;
        }

        public ConstraintValidatorContext addError() {
            ConstraintValidatorContextImpl.this.errorMessages.add(new ErrorMessage(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    class NodeBuilderImpl
    implements ConstraintValidatorContext.ErrorBuilder.NodeBuilderDefinedContext {
        String messageTemplate;
        PathImpl propertyPath;

        NodeBuilderImpl(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext.ErrorBuilder.NodeBuilderCustomizableContext addSubNode(String name) {
            NodeImpl node = new NodeImpl(name);
            this.propertyPath.addNode(node);
            return new InIterableNodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext addError() {
            ConstraintValidatorContextImpl.this.errorMessages.add(new ErrorMessage(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    class ErrorBuilderImpl
    implements ConstraintValidatorContext.ErrorBuilder {
        String messageTemplate;
        Path propertyPath;

        ErrorBuilderImpl(String template, Path path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext.ErrorBuilder.NodeBuilderDefinedContext addSubNode(String name) {
            PathImpl path = PathImpl.createShallowCopy(this.propertyPath);
            path.addNode(new NodeImpl(name));
            return new NodeBuilderImpl(this.messageTemplate, path);
        }

        public ConstraintValidatorContext addError() {
            ConstraintValidatorContextImpl.this.errorMessages.add(new ErrorMessage(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    public class ErrorMessage {
        private final String message;
        private final Path propertyPath;

        public ErrorMessage(String message, Path property) {
            this.message = message;
            this.propertyPath = property;
        }

        public String getMessage() {
            return this.message;
        }

        public Path getPath() {
            return this.propertyPath;
        }
    }
}

