/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.felix.shell.impl.PsCommandImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FindCommandImpl
extends PsCommandImpl {
    public FindCommandImpl(BundleContext context) {
        super(context);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() < 2) {
            out.println("Please specify a bundle name");
            return;
        }
        st.nextToken();
        String pattern = st.nextToken();
        Bundle[] bundles = this.m_context.getBundles();
        ArrayList<Bundle> found = new ArrayList<Bundle>();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            if (!this.match(bundle.getSymbolicName(), pattern) && !this.match(name, pattern)) continue;
            found.add(bundle);
        }
        if (found.size() > 0) {
            this.printBundleList(found.toArray(new Bundle[found.size()]), null, out, false, false, false);
        } else {
            out.println("No matching bundles found");
        }
    }

    private boolean match(String name, String pattern) {
        return name != null && name.toLowerCase().contains(pattern.toLowerCase());
    }

    public String getName() {
        return "find";
    }

    public String getShortDescription() {
        return "find bundles by name.";
    }

    public String getUsage() {
        return "find <bundle name>";
    }
}

