/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.single;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestProxy
extends Manifest {
    public final Map<String, Attributes> attributes = new HashMap<String, Attributes>();
    public final Attributes mainAttributes = new Attributes();
    public final Map<String, String> mappings = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManifestProxy(ClassLoader cl, List<SeparatorMappings> mappings) throws IOException {
        try {
            if (mappings != null) {
                for (SeparatorMappings mapping : mappings) {
                    this.mappings.put(mapping.key, mapping.separator);
                }
            }
            Method met = cl.getClass().getMethod("findResources", String.class);
            Enumeration urls = null;
            try {
                urls = (Enumeration)met.invoke((Object)cl, "META-INF/MANIFEST.MF");
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ManifestProxy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ManifestProxy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(ManifestProxy.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (urls == null) {
                return;
            }
            while (urls.hasMoreElements()) {
                URL url = (URL)urls.nextElement();
                InputStream is = null;
                try {
                    is = url.openStream();
                    Manifest m = new Manifest(is);
                    for (Map.Entry<String, Attributes> attr : m.getEntries().entrySet()) {
                        if (this.attributes.containsKey(attr.getKey())) {
                            this.merge(this.attributes.get(attr.getKey()), attr.getValue());
                            continue;
                        }
                        this.attributes.put(attr.getKey(), new Attributes(attr.getValue()));
                    }
                    this.merge(this.mainAttributes, m.getMainAttributes());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(ManifestProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(ManifestProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void merge(Attributes target, Attributes source) {
        for (Object o : source.keySet()) {
            if (target.containsKey(o)) {
                String sep = this.mappings.containsKey(o.toString()) ? this.mappings.get(o.toString()) : ",";
                String newValue = target.get(o) + sep + source.get(o);
                target.put(o, newValue);
                continue;
            }
            target.put(o, source.get(o));
        }
    }

    @Override
    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    @Override
    public Map<String, Attributes> getEntries() {
        return this.attributes;
    }

    @Override
    public Attributes getAttributes(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void clear() {
        this.mainAttributes.clear();
        this.attributes.clear();
    }

    @Override
    public void write(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void read(InputStream is) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static final class SeparatorMappings {
        final String key;
        final String separator;

        public SeparatorMappings(String key, String separator) {
            this.key = key;
            this.separator = separator;
        }
    }
}

