/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.jtype;

import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import org.hibernate.validation.jtype.ClassSerializer;
import org.hibernate.validation.jtype.ClassSerializers;
import org.hibernate.validation.jtype.TypeUtils;
import org.hibernate.validation.jtype.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultParameterizedType
implements ParameterizedType {
    private final Type ownerType;
    private final Type rawType;
    private final Type[] actualTypeArguments;

    public DefaultParameterizedType(Type ownerType, Class<?> rawType, Type[] actualTypeArguments) {
        TypeVariable<Class<?>>[] typeParameters;
        this.rawType = Utils.checkNotNull(rawType, "rawType");
        if (actualTypeArguments == null) {
            actualTypeArguments = new Type[]{};
        }
        if ((typeParameters = rawType.getTypeParameters()).length != actualTypeArguments.length) {
            throw new MalformedParameterizedTypeException();
        }
        if (ownerType == null) {
            ownerType = rawType.getDeclaringClass();
        }
        this.ownerType = ownerType;
        this.actualTypeArguments = (Type[])actualTypeArguments.clone();
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    public int hashCode() {
        int hashCode = Utils.nullHashCode(this.ownerType);
        hashCode = 37 * hashCode + this.rawType.hashCode();
        hashCode = 37 * hashCode + Arrays.hashCode(this.actualTypeArguments);
        return hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType type = (ParameterizedType)object;
        if (type == this) {
            return true;
        }
        return Utils.nullEquals(this.ownerType, type.getOwnerType()) && this.rawType.equals(type.getRawType()) && Arrays.equals(this.actualTypeArguments, type.getActualTypeArguments());
    }

    public String toString() {
        return DefaultParameterizedType.toString(this);
    }

    public static String toString(ParameterizedType type) {
        return DefaultParameterizedType.toString(type, ClassSerializers.QUALIFIED);
    }

    public static String toString(ParameterizedType type, ClassSerializer serializer) {
        StringBuilder builder = new StringBuilder();
        Type ownerType = type.getOwnerType();
        if (ownerType != null) {
            builder.append(TypeUtils.toString(ownerType, serializer));
            builder.append(".");
        }
        builder.append(TypeUtils.toString(type.getRawType(), serializer));
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            builder.append("<");
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(TypeUtils.toString(actualTypeArguments[i], serializer));
            }
            builder.append(">");
        }
        return builder.toString();
    }
}

