/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.grizzly.http.KeepAliveStats;

public class MonitorableKeepAliveStats
extends KeepAliveStats {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String listenerName;

    public MonitorableKeepAliveStats(GrizzlyMonitoring grizzlyMonitoring, String listenerName) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.listenerName = listenerName;
        if (grizzlyMonitoring != null) {
            this.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
            this.setKeepAliveTimeoutInSeconds(this.getKeepAliveTimeoutInSeconds());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        super.setMaxKeepAliveRequests(maxKeepAliveRequests);
        this.grizzlyMonitoring.getKeepAliveProbeProvider().setMaxCountRequestsEvent(this.listenerName, maxKeepAliveRequests);
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        super.setKeepAliveTimeoutInSeconds(timeout);
        this.grizzlyMonitoring.getKeepAliveProbeProvider().setTimeoutInSecondsEvent(this.listenerName, timeout);
    }

    public void incrementCountConnections() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountConnectionsEvent(this.listenerName);
    }

    protected void decrementCountConnections() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().decrementCountConnectionsEvent(this.listenerName);
    }

    public void incrementCountFlushes() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountFlushesEvent(this.listenerName);
    }

    public void incrementCountHits() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountHitsEvent(this.listenerName);
    }

    public void incrementCountRefusals() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountRefusalsEvent(this.listenerName);
    }

    public void incrementCountTimeouts() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountTimeoutsEvent(this.listenerName);
    }
}

