/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.MonitorableWorkerThread;
import com.sun.enterprise.v3.services.impl.monitor.probes.ThreadPoolProbeProvider;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.util.FixedThreadPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MonitorableThreadPool
extends StatsThreadPool {
    private final GrizzlyMonitoring monitoring;
    private final String monitoringName;

    public MonitorableThreadPool(GrizzlyMonitoring monitoring, String monitoringName) {
        this.monitoring = monitoring;
        this.monitoringName = monitoringName;
        this.setThreadFactory(new ProbeWorkerThreadFactory());
        ThreadPoolProbeProvider threadPoolProbeProvider = monitoring.getThreadPoolProbeProvider();
        threadPoolProbeProvider.setCoreThreadsEvent(monitoringName, this.corePoolSize);
        threadPoolProbeProvider.setMaxThreadsEvent(monitoringName, this.maxPoolSize);
        monitoring.getConnectionQueueProbeProvider().setMaxTaskQueueSizeEvent(monitoringName, this.workQueue.remainingCapacity());
    }

    public MonitorableThreadPool(GrizzlyMonitoring monitoring, String threadPoolMonitoringName, String threadPoolName, int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        super(threadPoolName, corePoolSize, maximumPoolSize, maxTasksCount, keepAliveTime, unit);
        this.monitoring = monitoring;
        this.monitoringName = threadPoolMonitoringName;
        this.setThreadFactory(new ProbeWorkerThreadFactory());
        ThreadPoolProbeProvider threadPoolProbeProvider = monitoring.getThreadPoolProbeProvider();
        threadPoolProbeProvider.setCoreThreadsEvent(threadPoolMonitoringName, this.corePoolSize);
        threadPoolProbeProvider.setMaxThreadsEvent(threadPoolMonitoringName, this.maxPoolSize);
        monitoring.getConnectionQueueProbeProvider().setMaxTaskQueueSizeEvent(this.monitoringName, this.workQueue.remainingCapacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            super.setCorePoolSize(corePoolSize);
            if (this.monitoring == null) {
                return;
            }
            this.monitoring.getThreadPoolProbeProvider().setCoreThreadsEvent(this.monitoringName, corePoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            super.setMaximumPoolSize(maxPoolSize);
            if (this.monitoring == null) {
                return;
            }
            this.monitoring.getThreadPoolProbeProvider().setMaxThreadsEvent(this.monitoringName, maxPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPoolSizes(int corePoolSize, int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            super.setPoolSizes(corePoolSize, maxPoolSize);
            if (this.monitoring == null) {
                return;
            }
            ThreadPoolProbeProvider threadPoolProbeProvider = this.monitoring.getThreadPoolProbeProvider();
            threadPoolProbeProvider.setCoreThreadsEvent(this.monitoringName, corePoolSize);
            threadPoolProbeProvider.setMaxThreadsEvent(this.monitoringName, maxPoolSize);
        }
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.monitoring.getThreadPoolProbeProvider().threadDispatchedFromPoolEvent(this.monitoringName, thread.getName());
    }

    protected void afterExecute(Runnable r, Throwable t) {
        this.monitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringName, Thread.currentThread().getName());
        super.afterExecute(r, t);
    }

    protected void onWorkerExit(FixedThreadPool.BasicWorker worker) {
        this.monitoring.getThreadPoolProbeProvider().threadReleasedEvent(this.monitoringName, Thread.currentThread().getName());
        super.onWorkerExit(worker);
    }

    protected void onTaskQueued(Runnable task) {
        this.monitoring.getConnectionQueueProbeProvider().onTaskQueuedEvent(this.monitoringName, task);
        super.onTaskQueued(task);
    }

    protected void onTaskDequeued(Runnable task) {
        this.monitoring.getConnectionQueueProbeProvider().onTaskDequeuedEvent(this.monitoringName, task);
        super.onTaskDequeued(task);
    }

    protected void onTaskQueueOverflow() {
        this.monitoring.getConnectionQueueProbeProvider().onTaskQueueOverflowEvent(this.monitoringName);
        super.onTaskQueueOverflow();
    }

    public class ProbeWorkerThreadFactory
    implements ThreadFactory {
        public Thread newThread(Runnable r) {
            MonitorableWorkerThread thread = new MonitorableWorkerThread(MonitorableThreadPool.this, r, MonitorableThreadPool.this.name + "-(" + MonitorableThreadPool.this.workerThreadCounter.getAndIncrement() + ")", MonitorableThreadPool.this.initialByteBufferSize, MonitorableThreadPool.this.monitoring);
            MonitorableThreadPool.this.monitoring.getThreadPoolProbeProvider().threadAllocatedEvent(MonitorableThreadPool.this.monitoringName, ((Thread)((Object)thread)).getName());
            return thread;
        }
    }
}

